#!/bin/sh

# this shell script refreshes world timezone definitions in
#   cores/esp8266/TZ.h
#
# to run it, use:
#   /path/to/TZupdate.sh
#   tools/TZupdate.sh
#   ./TZupdate.sh

dir=$(cd ${0%/*} 2>/dev/null; pwd)
base=${0##*/}

csv=https://raw.githubusercontent.com/nayarsystems/posix_tz_db/master/zones.csv

set -e

tz_tmpdir=$(mktemp -d)
trap 'rm -r $tz_tmpdir' EXIT

input=$tz_tmpdir/zones.csv
names=$tz_tmpdir/names.txt
values=$tz_tmpdir/values.txt

wget -O $input $csv  || curl $csv > $input

sed -e 's/^[^,]*,//g' -e 's,^,PSTR(,g' -e 's,$,),g' < $input > $values
sed -e 's/^\([^,]*\),.*/#define TZ_\1/g' -e 's,["],,g' < $input | tr '/\-+' '_mp' > $names

(

cat << EOF

// autogenerated from $csv
// by script <esp8266 arduino core>/tools/${base}
// $(date -u)
//
// This database is autogenerated from IANA timezone database
//    ${csv}
//    (using https://www.iana.org/time-zones)
// and can be updated on demand in this repository
// or by yourself using the above script

#ifndef TZDB_H
#define TZDB_H

EOF

paste $names $values

cat << EOF

#endif // TZDB_H
EOF

) > $tz_tmpdir/TZ.h

backup=$(date +%s)
mv ${dir}/../cores/esp8266/TZ.h ${dir}/../cores/esp8266/TZ.h.$backup
mv $tz_tmpdir/TZ.h ${dir}/../cores/esp8266/TZ.h

cat << EOF

Done:
    '${dir}/../cores/esp8266/TZ.h' is updated

Diff:
----8<-------8<------8<---
$(diff -u ${dir}/../cores/esp8266/TZ.h.$backup ${dir}/../cores/esp8266/TZ.h)
--->8----->8------>8------

EOF
