"""
t3SINI.py

Provides a class representing a static initializer block in a t3 image file.
"""

import struct
from t3Block import *

class SINI_Block(Block):
	"""
	A static initializer list block.
	"""
	name = "Static Initializer List Block"
	debug = True

	def __init__(self, datastream, image, attribs):
		Block.__init__(self, datastream, image, attribs)
		self.read_block()
		
	def read_block(self):
		"""
		Reads the data included in the block.
		"""
		headersz = struct.unpack("<I", self.datastream.read(4))[0]
		scdploffset = struct.unpack("<I", self.datastream.read(4))[0]
		initcount = struct.unpack("<I", self.datastream.read(4))[0]
		self.data["i_staticCodePoolOffset"] = scdploffset
		# future proofing to ignore any added fields
		if headersz > 12:
			datastream.read(headersz-12)
		entries = []
		for i in xrange(initcount):
			entries.append(struct.unpack("<IH", self.datastream.read(6)))
		self.data["l_entries"] = entries

	def report_data(self):
		sl = []
		sl.append("static codepool offset: ")
		sl.append(str(self.data["i_staticCodePoolOffset"]))
		for entry in self.data["l_entries"]:
			sl.append("\n")
			sl.append("objID/propID: ")
			sl.append(str(entry[0]) + " " + str(entry[1]) + "\n")
		return "".join(sl)