/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class Jetty {
    public static GameState state = null;
    public static OutputFormatter out = null;
    public static InputHandler in = null;
    public static Parser parser = null;
    public static Simulator simulator = null;
    public static CodeRunner runner = null;
    public static ParserError perror = null;
    private InputStream _file;
    private static int _debug_level = 1;

    public Jetty(PlatformIO platformIO, InputStream inputStream) {
        out = new OutputFormatter(platformIO);
        in = new InputHandler(platformIO);
        platformIO.set_out(out);
        this._file = inputStream;
    }

    public boolean load() {
        try {
            GameFileParser gameFileParser = new GameFileParser();
            state = gameFileParser.read(this._file);
            if (state == null) {
                return false;
            }
            state.init();
        }
        catch (IOException iOException) {
            out.print_error("I/O error reading gamefile: " + iOException, 0);
            return false;
        }
        catch (HaltTurnException haltTurnException) {
            out.print_error("Internal error reading gamefile: " + haltTurnException, 0);
            return false;
        }
        runner = new CodeRunner();
        perror = new ParserError();
        simulator = new Simulator();
        parser = new Parser();
        return true;
    }

    public void run() {
        try {
            TObject tObject;
            TObject tObject2 = state.get_preinit();
            if (state.run_preinit() && tObject2 != null) {
                try {
                    runner.run(tObject2.get_data(), TObject.arg_array(), tObject2);
                }
                catch (ParseException parseException) {
                    out.print_error("Parse exception (" + parseException + ") erroneously thrown in preinit()", 1);
                }
                catch (ReparseException reparseException) {
                    out.print_error("Reparse exception erroneously thrown in preinit()", 1);
                }
            }
            if ((tObject = state.lookup_required_object(6)) == null) {
                out.print_error("Error: no init function found", 0);
                throw new GameOverException();
            }
            try {
                runner.run(tObject.get_data(), TObject.arg_array(), tObject);
            }
            catch (ParseException parseException) {
                out.print_error("Parse exception (" + parseException + ") erroneously thrown in init()", 1);
            }
            catch (ReparseException reparseException) {
                out.print_error("Reparse exception erroneously thrown in init()", 1);
            }
            while (true) {
                parser.run_turn();
            }
        }
        catch (GameOverException gameOverException) {
            System.out.println("\n[The game has ended.]");
            out.flush();
            return;
        }
    }

    public static int get_debug_level() {
        return _debug_level;
    }

    public static void set_debug_level(int n) {
        _debug_level = n;
    }
}

