/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.datetime;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.buildins.datetime.DateTimePrologCode;

public class Predicate_date_time_value
extends DateTimePrologCode {
    public static final AtomTerm yearAtom = AtomTerm.get("year");
    public static final AtomTerm monthAtom = AtomTerm.get("month");
    public static final AtomTerm dayAtom = AtomTerm.get("day");
    public static final AtomTerm hourAtom = AtomTerm.get("hour");
    public static final AtomTerm minuteAtom = AtomTerm.get("minute");
    public static final AtomTerm secondAtom = AtomTerm.get("second");
    public static final AtomTerm utcOffsetAtom = AtomTerm.get("utc_offset");
    public static final AtomTerm timeZoneAtom = AtomTerm.get("time_zone");
    public static final AtomTerm daylightSavingAtom = AtomTerm.get("daylight_saving");
    public static final AtomTerm[] date9keys = new AtomTerm[]{yearAtom, monthAtom, dayAtom, hourAtom, minuteAtom, secondAtom, utcOffsetAtom, timeZoneAtom, daylightSavingAtom, dateAtom, timeAtom};

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            Date9BacktrackInfo bi = (Date9BacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return this.nextSolution(interpreter, bi);
        }
        if (!(args[1] instanceof CompoundTerm)) {
            PrologException.typeError(dateAtom, args[1]);
        }
        CompoundTerm date9 = (CompoundTerm)args[1];
        if (date9.tag != date9Tag) {
            PrologException.typeError(dateAtom, args[1]);
        }
        if (date9.args.length != 9) {
            PrologException.typeError(dateAtom, args[1]);
        }
        if (args[0] instanceof VariableTerm) {
            Date9BacktrackInfo bi = new Date9BacktrackInfo();
            bi.startUndoPosition = interpreter.getUndoPosition();
            bi.key = args[0];
            bi.value = args[2];
            bi.date9 = date9;
            return this.nextSolution(interpreter, bi);
        }
        Term res = this.getDate9Value(args[0], date9);
        if (res == null) {
            return -1;
        }
        return interpreter.unify(args[2], res);
    }

    protected Term getDate9Value(Term keyTerm, CompoundTerm date9) throws PrologException {
        AtomTerm key;
        if (!(keyTerm instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, keyTerm);
        }
        if ((key = (AtomTerm)keyTerm) == yearAtom) {
            return date9.args[0];
        }
        if (key == monthAtom) {
            return date9.args[1];
        }
        if (key == dayAtom) {
            return date9.args[2];
        }
        if (key == hourAtom) {
            return date9.args[3];
        }
        if (key == minuteAtom) {
            return date9.args[4];
        }
        if (key == secondAtom) {
            return date9.args[5];
        }
        if (key == utcOffsetAtom) {
            return date9.args[6];
        }
        if (key == timeZoneAtom) {
            if (date9.args[7] == AtomTerm.get("-")) {
                return null;
            }
            return date9.args[7];
        }
        if (key == daylightSavingAtom) {
            if (date9.args[8] == AtomTerm.get("-")) {
                return null;
            }
            return date9.args[8];
        }
        if (key == dateAtom) {
            return new CompoundTerm(date3Tag, new Term[]{date9.args[0], date9.args[1], date9.args[2]});
        }
        if (key == timeAtom) {
            return new CompoundTerm(date3Tag, new Term[]{date9.args[3], date9.args[4], date9.args[5]});
        }
        return null;
    }

    protected int nextSolution(Interpreter interpreter, Date9BacktrackInfo bi) throws PrologException {
        while (bi.date9idx < date9keys.length) {
            AtomTerm key = date9keys[bi.date9idx];
            Term res = this.getDate9Value(key, bi.date9);
            ++bi.date9idx;
            if (res == null) continue;
            if (interpreter.unify(bi.value, res) == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            if (interpreter.unify(bi.key, key) == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            interpreter.pushBacktrackInfo(bi);
            return 0;
        }
        return -1;
    }

    static class Date9BacktrackInfo
    extends BacktrackInfo {
        Term key;
        CompoundTerm date9;
        Term value;
        int date9idx;
        int startUndoPosition;

        public Date9BacktrackInfo() {
            super(-1, -1);
        }
    }
}

