--TEST--
fpow() function
--FILE--
<?php

$numbers = [
    0,
    1,
    -1,
    1.0,
    -1.0,
    2,
    -2,
    2.1,
    -2.1,
    0.1,
    -0.1,
    0.0,
    -0.0,
    10,
    -10,
    INF,
    -INF,
    NAN,
];

function safe_to_string(int|float $number): string {
    if (is_nan($number)) {
        return 'NAN';
    }
    return $number;
}

foreach ($numbers as $base) {
    foreach ($numbers as $exp) {
        echo str_pad(safe_to_string($base), 4, " ", STR_PAD_LEFT),
            " ** ",
            str_pad(safe_to_string($exp), 4),
            " = ",
            safe_to_string(fpow($base, $exp)),
            PHP_EOL;
    }
}
?>
--EXPECT--
   0 ** 0    = 1
   0 ** 1    = 0
   0 ** -1   = INF
   0 ** 1    = 0
   0 ** -1   = INF
   0 ** 2    = 0
   0 ** -2   = INF
   0 ** 2.1  = 0
   0 ** -2.1 = INF
   0 ** 0.1  = 0
   0 ** -0.1 = INF
   0 ** 0    = 1
   0 ** -0   = 1
   0 ** 10   = 0
   0 ** -10  = INF
   0 ** INF  = 0
   0 ** -INF = INF
   0 ** NAN  = NAN
   1 ** 0    = 1
   1 ** 1    = 1
   1 ** -1   = 1
   1 ** 1    = 1
   1 ** -1   = 1
   1 ** 2    = 1
   1 ** -2   = 1
   1 ** 2.1  = 1
   1 ** -2.1 = 1
   1 ** 0.1  = 1
   1 ** -0.1 = 1
   1 ** 0    = 1
   1 ** -0   = 1
   1 ** 10   = 1
   1 ** -10  = 1
   1 ** INF  = 1
   1 ** -INF = 1
   1 ** NAN  = 1
  -1 ** 0    = 1
  -1 ** 1    = -1
  -1 ** -1   = -1
  -1 ** 1    = -1
  -1 ** -1   = -1
  -1 ** 2    = 1
  -1 ** -2   = 1
  -1 ** 2.1  = NAN
  -1 ** -2.1 = NAN
  -1 ** 0.1  = NAN
  -1 ** -0.1 = NAN
  -1 ** 0    = 1
  -1 ** -0   = 1
  -1 ** 10   = 1
  -1 ** -10  = 1
  -1 ** INF  = 1
  -1 ** -INF = 1
  -1 ** NAN  = NAN
   1 ** 0    = 1
   1 ** 1    = 1
   1 ** -1   = 1
   1 ** 1    = 1
   1 ** -1   = 1
   1 ** 2    = 1
   1 ** -2   = 1
   1 ** 2.1  = 1
   1 ** -2.1 = 1
   1 ** 0.1  = 1
   1 ** -0.1 = 1
   1 ** 0    = 1
   1 ** -0   = 1
   1 ** 10   = 1
   1 ** -10  = 1
   1 ** INF  = 1
   1 ** -INF = 1
   1 ** NAN  = 1
  -1 ** 0    = 1
  -1 ** 1    = -1
  -1 ** -1   = -1
  -1 ** 1    = -1
  -1 ** -1   = -1
  -1 ** 2    = 1
  -1 ** -2   = 1
  -1 ** 2.1  = NAN
  -1 ** -2.1 = NAN
  -1 ** 0.1  = NAN
  -1 ** -0.1 = NAN
  -1 ** 0    = 1
  -1 ** -0   = 1
  -1 ** 10   = 1
  -1 ** -10  = 1
  -1 ** INF  = 1
  -1 ** -INF = 1
  -1 ** NAN  = NAN
   2 ** 0    = 1
   2 ** 1    = 2
   2 ** -1   = 0.5
   2 ** 1    = 2
   2 ** -1   = 0.5
   2 ** 2    = 4
   2 ** -2   = 0.25
   2 ** 2.1  = 4.2870938501452
   2 ** -2.1 = 0.2332582478842
   2 ** 0.1  = 1.0717734625363
   2 ** -0.1 = 0.93303299153681
   2 ** 0    = 1
   2 ** -0   = 1
   2 ** 10   = 1024
   2 ** -10  = 0.0009765625
   2 ** INF  = INF
   2 ** -INF = 0
   2 ** NAN  = NAN
  -2 ** 0    = 1
  -2 ** 1    = -2
  -2 ** -1   = -0.5
  -2 ** 1    = -2
  -2 ** -1   = -0.5
  -2 ** 2    = 4
  -2 ** -2   = 0.25
  -2 ** 2.1  = NAN
  -2 ** -2.1 = NAN
  -2 ** 0.1  = NAN
  -2 ** -0.1 = NAN
  -2 ** 0    = 1
  -2 ** -0   = 1
  -2 ** 10   = 1024
  -2 ** -10  = 0.0009765625
  -2 ** INF  = INF
  -2 ** -INF = 0
  -2 ** NAN  = NAN
 2.1 ** 0    = 1
 2.1 ** 1    = 2.1
 2.1 ** -1   = 0.47619047619048
 2.1 ** 1    = 2.1
 2.1 ** -1   = 0.47619047619048
 2.1 ** 2    = 4.41
 2.1 ** -2   = 0.22675736961451
 2.1 ** 2.1  = 4.7496380917422
 2.1 ** -2.1 = 0.21054235726688
 2.1 ** 0.1  = 1.0770154403044
 2.1 ** -0.1 = 0.92849179554696
 2.1 ** 0    = 1
 2.1 ** -0   = 1
 2.1 ** 10   = 1667.9880978201
 2.1 ** -10  = 0.0005995246616609
 2.1 ** INF  = INF
 2.1 ** -INF = 0
 2.1 ** NAN  = NAN
-2.1 ** 0    = 1
-2.1 ** 1    = -2.1
-2.1 ** -1   = -0.47619047619048
-2.1 ** 1    = -2.1
-2.1 ** -1   = -0.47619047619048
-2.1 ** 2    = 4.41
-2.1 ** -2   = 0.22675736961451
-2.1 ** 2.1  = NAN
-2.1 ** -2.1 = NAN
-2.1 ** 0.1  = NAN
-2.1 ** -0.1 = NAN
-2.1 ** 0    = 1
-2.1 ** -0   = 1
-2.1 ** 10   = 1667.9880978201
-2.1 ** -10  = 0.0005995246616609
-2.1 ** INF  = INF
-2.1 ** -INF = 0
-2.1 ** NAN  = NAN
 0.1 ** 0    = 1
 0.1 ** 1    = 0.1
 0.1 ** -1   = 10
 0.1 ** 1    = 0.1
 0.1 ** -1   = 10
 0.1 ** 2    = 0.01
 0.1 ** -2   = 100
 0.1 ** 2.1  = 0.0079432823472428
 0.1 ** -2.1 = 125.89254117942
 0.1 ** 0.1  = 0.79432823472428
 0.1 ** -0.1 = 1.2589254117942
 0.1 ** 0    = 1
 0.1 ** -0   = 1
 0.1 ** 10   = 1.0E-10
 0.1 ** -10  = 10000000000
 0.1 ** INF  = 0
 0.1 ** -INF = INF
 0.1 ** NAN  = NAN
-0.1 ** 0    = 1
-0.1 ** 1    = -0.1
-0.1 ** -1   = -10
-0.1 ** 1    = -0.1
-0.1 ** -1   = -10
-0.1 ** 2    = 0.01
-0.1 ** -2   = 100
-0.1 ** 2.1  = NAN
-0.1 ** -2.1 = NAN
-0.1 ** 0.1  = NAN
-0.1 ** -0.1 = NAN
-0.1 ** 0    = 1
-0.1 ** -0   = 1
-0.1 ** 10   = 1.0E-10
-0.1 ** -10  = 10000000000
-0.1 ** INF  = 0
-0.1 ** -INF = INF
-0.1 ** NAN  = NAN
   0 ** 0    = 1
   0 ** 1    = 0
   0 ** -1   = INF
   0 ** 1    = 0
   0 ** -1   = INF
   0 ** 2    = 0
   0 ** -2   = INF
   0 ** 2.1  = 0
   0 ** -2.1 = INF
   0 ** 0.1  = 0
   0 ** -0.1 = INF
   0 ** 0    = 1
   0 ** -0   = 1
   0 ** 10   = 0
   0 ** -10  = INF
   0 ** INF  = 0
   0 ** -INF = INF
   0 ** NAN  = NAN
  -0 ** 0    = 1
  -0 ** 1    = -0
  -0 ** -1   = -INF
  -0 ** 1    = -0
  -0 ** -1   = -INF
  -0 ** 2    = 0
  -0 ** -2   = INF
  -0 ** 2.1  = 0
  -0 ** -2.1 = INF
  -0 ** 0.1  = 0
  -0 ** -0.1 = INF
  -0 ** 0    = 1
  -0 ** -0   = 1
  -0 ** 10   = 0
  -0 ** -10  = INF
  -0 ** INF  = 0
  -0 ** -INF = INF
  -0 ** NAN  = NAN
  10 ** 0    = 1
  10 ** 1    = 10
  10 ** -1   = 0.1
  10 ** 1    = 10
  10 ** -1   = 0.1
  10 ** 2    = 100
  10 ** -2   = 0.01
  10 ** 2.1  = 125.89254117942
  10 ** -2.1 = 0.0079432823472428
  10 ** 0.1  = 1.2589254117942
  10 ** -0.1 = 0.79432823472428
  10 ** 0    = 1
  10 ** -0   = 1
  10 ** 10   = 10000000000
  10 ** -10  = 1.0E-10
  10 ** INF  = INF
  10 ** -INF = 0
  10 ** NAN  = NAN
 -10 ** 0    = 1
 -10 ** 1    = -10
 -10 ** -1   = -0.1
 -10 ** 1    = -10
 -10 ** -1   = -0.1
 -10 ** 2    = 100
 -10 ** -2   = 0.01
 -10 ** 2.1  = NAN
 -10 ** -2.1 = NAN
 -10 ** 0.1  = NAN
 -10 ** -0.1 = NAN
 -10 ** 0    = 1
 -10 ** -0   = 1
 -10 ** 10   = 10000000000
 -10 ** -10  = 1.0E-10
 -10 ** INF  = INF
 -10 ** -INF = 0
 -10 ** NAN  = NAN
 INF ** 0    = 1
 INF ** 1    = INF
 INF ** -1   = 0
 INF ** 1    = INF
 INF ** -1   = 0
 INF ** 2    = INF
 INF ** -2   = 0
 INF ** 2.1  = INF
 INF ** -2.1 = 0
 INF ** 0.1  = INF
 INF ** -0.1 = 0
 INF ** 0    = 1
 INF ** -0   = 1
 INF ** 10   = INF
 INF ** -10  = 0
 INF ** INF  = INF
 INF ** -INF = 0
 INF ** NAN  = NAN
-INF ** 0    = 1
-INF ** 1    = -INF
-INF ** -1   = -0
-INF ** 1    = -INF
-INF ** -1   = -0
-INF ** 2    = INF
-INF ** -2   = 0
-INF ** 2.1  = INF
-INF ** -2.1 = 0
-INF ** 0.1  = INF
-INF ** -0.1 = 0
-INF ** 0    = 1
-INF ** -0   = 1
-INF ** 10   = INF
-INF ** -10  = 0
-INF ** INF  = INF
-INF ** -INF = 0
-INF ** NAN  = NAN
 NAN ** 0    = 1
 NAN ** 1    = NAN
 NAN ** -1   = NAN
 NAN ** 1    = NAN
 NAN ** -1   = NAN
 NAN ** 2    = NAN
 NAN ** -2   = NAN
 NAN ** 2.1  = NAN
 NAN ** -2.1 = NAN
 NAN ** 0.1  = NAN
 NAN ** -0.1 = NAN
 NAN ** 0    = 1
 NAN ** -0   = 1
 NAN ** 10   = NAN
 NAN ** -10  = NAN
 NAN ** INF  = NAN
 NAN ** -INF = NAN
 NAN ** NAN  = NAN
