# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ClusterScopeSettings(ProxyResource):
    """Extension scope settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar allow_multiple_instances: Describes if multiple instances of the extension are allowed.
    :vartype allow_multiple_instances: bool
    :ivar default_release_namespace: Default extension release namespace.
    :vartype default_release_namespace: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "allow_multiple_instances": {"key": "properties.allowMultipleInstances", "type": "bool"},
        "default_release_namespace": {"key": "properties.defaultReleaseNamespace", "type": "str"},
    }

    def __init__(
        self,
        *,
        allow_multiple_instances: Optional[bool] = None,
        default_release_namespace: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow_multiple_instances: Describes if multiple instances of the extension are
         allowed.
        :paramtype allow_multiple_instances: bool
        :keyword default_release_namespace: Default extension release namespace.
        :paramtype default_release_namespace: str
        """
        super().__init__(**kwargs)
        self.allow_multiple_instances = allow_multiple_instances
        self.default_release_namespace = default_release_namespace


class ComplianceStatus(_serialization.Model):
    """Compliance Status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_state: The compliance state of the configuration. Known values are: "Pending",
     "Compliant", "Noncompliant", "Installed", and "Failed".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ComplianceStateType
    :ivar last_config_applied: Datetime the configuration was last applied.
    :vartype last_config_applied: ~datetime.datetime
    :ivar message: Message from when the configuration was applied.
    :vartype message: str
    :ivar message_level: Level of the message. Known values are: "Error", "Warning", and
     "Information".
    :vartype message_level: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.MessageLevelType
    """

    _validation = {
        "compliance_state": {"readonly": True},
    }

    _attribute_map = {
        "compliance_state": {"key": "complianceState", "type": "str"},
        "last_config_applied": {"key": "lastConfigApplied", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "message_level": {"key": "messageLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_config_applied: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        message_level: Optional[Union[str, "_models.MessageLevelType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_config_applied: Datetime the configuration was last applied.
        :paramtype last_config_applied: ~datetime.datetime
        :keyword message: Message from when the configuration was applied.
        :paramtype message: str
        :keyword message_level: Level of the message. Known values are: "Error", "Warning", and
         "Information".
        :paramtype message_level: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.MessageLevelType
        """
        super().__init__(**kwargs)
        self.compliance_state = None
        self.last_config_applied = last_config_applied
        self.message = message
        self.message_level = message_level


class DependsOnDefinition(_serialization.Model):
    """Specify which kustomizations must succeed reconciliation on the cluster prior to reconciling
    this kustomization.

    :ivar kustomization_name: Name of the kustomization to claim dependency on.
    :vartype kustomization_name: str
    """

    _attribute_map = {
        "kustomization_name": {"key": "kustomizationName", "type": "str"},
    }

    def __init__(self, *, kustomization_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kustomization_name: Name of the kustomization to claim dependency on.
        :paramtype kustomization_name: str
        """
        super().__init__(**kwargs)
        self.kustomization_name = kustomization_name


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Extension(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Extension object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: Identity of the Extension resource.
    :vartype identity: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.Identity
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SystemData
    :ivar extension_type: Type of the Extension, of which this resource is an instance of.  It must
     be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
     Extension publisher.
    :vartype extension_type: str
    :ivar auto_upgrade_minor_version: Flag to note if this extension participates in auto upgrade
     of minor version, or not.
    :vartype auto_upgrade_minor_version: bool
    :ivar release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable,
     Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :vartype release_train: str
    :ivar version: Version of the extension for this extension, if it is 'pinned' to a specific
     version. autoUpgradeMinorVersion must be 'false'.
    :vartype version: str
    :ivar scope: Scope at which the extension is installed.
    :vartype scope: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.Scope
    :ivar configuration_settings: Configuration settings, as name-value pairs for configuring this
     extension.
    :vartype configuration_settings: dict[str, str]
    :ivar configuration_protected_settings: Configuration settings that are sensitive, as
     name-value pairs for configuring this extension.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar provisioning_state: Status of installation of this extension. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ProvisioningState
    :ivar statuses: Status from this extension.
    :vartype statuses:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ExtensionStatus]
    :ivar error_info: Error information from the Agent - e.g. errors during installation.
    :vartype error_info: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ErrorDetail
    :ivar custom_location_settings: Custom Location settings properties.
    :vartype custom_location_settings: dict[str, str]
    :ivar package_uri: Uri of the Helm package.
    :vartype package_uri: str
    :ivar aks_assigned_identity: Identity of the Extension resource in an AKS cluster.
    :vartype aks_assigned_identity:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ExtensionPropertiesAksAssignedIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "error_info": {"readonly": True},
        "custom_location_settings": {"readonly": True},
        "package_uri": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extension_type": {"key": "properties.extensionType", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "release_train": {"key": "properties.releaseTrain", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "scope": {"key": "properties.scope", "type": "Scope"},
        "configuration_settings": {"key": "properties.configurationSettings", "type": "{str}"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ExtensionStatus]"},
        "error_info": {"key": "properties.errorInfo", "type": "ErrorDetail"},
        "custom_location_settings": {"key": "properties.customLocationSettings", "type": "{str}"},
        "package_uri": {"key": "properties.packageUri", "type": "str"},
        "aks_assigned_identity": {
            "key": "properties.aksAssignedIdentity",
            "type": "ExtensionPropertiesAksAssignedIdentity",
        },
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.Identity"] = None,
        extension_type: Optional[str] = None,
        auto_upgrade_minor_version: bool = True,
        release_train: str = "Stable",
        version: Optional[str] = None,
        scope: Optional["_models.Scope"] = None,
        configuration_settings: Optional[Dict[str, str]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        statuses: Optional[List["_models.ExtensionStatus"]] = None,
        aks_assigned_identity: Optional["_models.ExtensionPropertiesAksAssignedIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identity of the Extension resource.
        :paramtype identity: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.Identity
        :keyword extension_type: Type of the Extension, of which this resource is an instance of.  It
         must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
         Extension publisher.
        :paramtype extension_type: str
        :keyword auto_upgrade_minor_version: Flag to note if this extension participates in auto
         upgrade of minor version, or not.
        :paramtype auto_upgrade_minor_version: bool
        :keyword release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g.
         Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        :paramtype release_train: str
        :keyword version: Version of the extension for this extension, if it is 'pinned' to a specific
         version. autoUpgradeMinorVersion must be 'false'.
        :paramtype version: str
        :keyword scope: Scope at which the extension is installed.
        :paramtype scope: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.Scope
        :keyword configuration_settings: Configuration settings, as name-value pairs for configuring
         this extension.
        :paramtype configuration_settings: dict[str, str]
        :keyword configuration_protected_settings: Configuration settings that are sensitive, as
         name-value pairs for configuring this extension.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword statuses: Status from this extension.
        :paramtype statuses:
         list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ExtensionStatus]
        :keyword aks_assigned_identity: Identity of the Extension resource in an AKS cluster.
        :paramtype aks_assigned_identity:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ExtensionPropertiesAksAssignedIdentity
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.system_data = None
        self.extension_type = extension_type
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version
        self.scope = scope
        self.configuration_settings = configuration_settings
        self.configuration_protected_settings = configuration_protected_settings
        self.provisioning_state = None
        self.statuses = statuses
        self.error_info = None
        self.custom_location_settings = None
        self.package_uri = None
        self.aks_assigned_identity = aks_assigned_identity


class ExtensionPropertiesAksAssignedIdentity(_serialization.Model):
    """Identity of the Extension resource in an AKS cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Literal["SystemAssigned"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The identity type. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ExtensionsList(_serialization.Model):
    """Result of the request to list Extensions.  It contains a list of Extension objects and a URL
    link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Extensions within a Kubernetes cluster.
    :vartype value: list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.Extension]
    :ivar next_link: URL to get the next set of extension objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Extension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExtensionStatus(_serialization.Model):
    """Status from the extension.

    :ivar code: Status code provided by the Extension.
    :vartype code: str
    :ivar display_status: Short description of status of the extension.
    :vartype display_status: str
    :ivar level: Level of the status. Known values are: "Error", "Warning", and "Information".
    :vartype level: str or ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.LevelType
    :ivar message: Detailed message of the status from the Extension.
    :vartype message: str
    :ivar time: DateLiteral (per ISO8601) noting the time of installation status.
    :vartype time: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        level: Union[str, "_models.LevelType"] = "Information",
        message: Optional[str] = None,
        time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Status code provided by the Extension.
        :paramtype code: str
        :keyword display_status: Short description of status of the extension.
        :paramtype display_status: str
        :keyword level: Level of the status. Known values are: "Error", "Warning", and "Information".
        :paramtype level: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.LevelType
        :keyword message: Detailed message of the status from the Extension.
        :paramtype message: str
        :keyword time: DateLiteral (per ISO8601) noting the time of installation status.
        :paramtype time: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.display_status = display_status
        self.level = level
        self.message = message
        self.time = time


class ExtensionType(_serialization.Model):
    """Represents an Extension Type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SystemData
    :ivar release_trains: Extension release train: preview or stable.
    :vartype release_trains: list[str]
    :ivar cluster_types: Cluster types. Known values are: "connectedClusters" and
     "managedClusters".
    :vartype cluster_types: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ClusterTypes
    :ivar supported_scopes: Extension scopes.
    :vartype supported_scopes:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SupportedScopes
    """

    _validation = {
        "system_data": {"readonly": True},
        "release_trains": {"readonly": True},
        "cluster_types": {"readonly": True},
        "supported_scopes": {"readonly": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "release_trains": {"key": "properties.releaseTrains", "type": "[str]"},
        "cluster_types": {"key": "properties.clusterTypes", "type": "str"},
        "supported_scopes": {"key": "properties.supportedScopes", "type": "SupportedScopes"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data = None
        self.release_trains = None
        self.cluster_types = None
        self.supported_scopes = None


class ExtensionTypeList(_serialization.Model):
    """List Extension Types.

    :ivar value: The list of Extension Types.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ExtensionType]
    :ivar next_link: The link to fetch the next page of Extension Types.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExtensionType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExtensionType"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of Extension Types.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ExtensionType]
        :keyword next_link: The link to fetch the next page of Extension Types.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExtensionVersionList(_serialization.Model):
    """List versions for an Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar versions: Versions available for this Extension Type.
    :vartype versions:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ExtensionVersionListVersionsItem]
    :ivar next_link: The link to fetch the next page of Extension Types.
    :vartype next_link: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SystemData
    """

    _validation = {
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "versions": {"key": "versions", "type": "[ExtensionVersionListVersionsItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        versions: Optional[List["_models.ExtensionVersionListVersionsItem"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword versions: Versions available for this Extension Type.
        :paramtype versions:
         list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ExtensionVersionListVersionsItem]
        :keyword next_link: The link to fetch the next page of Extension Types.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.versions = versions
        self.next_link = next_link
        self.system_data = None


class ExtensionVersionListVersionsItem(_serialization.Model):
    """ExtensionVersionListVersionsItem.

    :ivar release_train: The release train for this Extension Type.
    :vartype release_train: str
    :ivar versions: Versions available for this Extension Type and release train.
    :vartype versions: list[str]
    """

    _attribute_map = {
        "release_train": {"key": "releaseTrain", "type": "str"},
        "versions": {"key": "versions", "type": "[str]"},
    }

    def __init__(
        self, *, release_train: Optional[str] = None, versions: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword release_train: The release train for this Extension Type.
        :paramtype release_train: str
        :keyword versions: Versions available for this Extension Type and release train.
        :paramtype versions: list[str]
        """
        super().__init__(**kwargs)
        self.release_train = release_train
        self.versions = versions


class FluxConfiguration(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Flux Configuration object returned in Get & Put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SystemData
    :ivar scope: Scope at which the operator will be installed. Known values are: "cluster" and
     "namespace".
    :vartype scope: str or ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ScopeType
    :ivar namespace: The namespace to which this configuration is installed to. Maximum of 253
     lower case alphanumeric characters, hyphen and period only.
    :vartype namespace: str
    :ivar source_kind: Source Kind to pull the configuration data from. "GitRepository"
    :vartype source_kind: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SourceKindType
    :ivar suspend: Whether this configuration should suspend its reconciliation of its
     kustomizations and sources.
    :vartype suspend: bool
    :ivar git_repository: Parameters to reconcile to the GitRepository source kind type.
    :vartype git_repository:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.GitRepositoryDefinition
    :ivar kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
     source type on the cluster.
    :vartype kustomizations: dict[str,
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.KustomizationDefinition]
    :ivar configuration_protected_settings: Key-value pairs of protected configuration settings for
     the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar statuses: Statuses of the Flux Kubernetes resources created by the fluxConfiguration or
     created by the managed objects provisioned by the fluxConfiguration.
    :vartype statuses:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ObjectStatusDefinition]
    :ivar repository_public_key: Public Key associated with this fluxConfiguration (either
     generated within the cluster or provided by the user).
    :vartype repository_public_key: str
    :ivar last_source_synced_commit_id: Branch and SHA of the last source commit synced with the
     cluster.
    :vartype last_source_synced_commit_id: str
    :ivar last_source_synced_at: Datetime the fluxConfiguration last synced its source on the
     cluster.
    :vartype last_source_synced_at: ~datetime.datetime
    :ivar compliance_state: Combined status of the Flux Kubernetes resources created by the
     fluxConfiguration or created by the managed objects. Known values are: "Compliant",
     "Non-Compliant", "Pending", "Suspended", and "Unknown".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.FluxComplianceState
    :ivar provisioning_state: Status of the creation of the fluxConfiguration. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ProvisioningState
    :ivar error_message: Error message returned to the user in the case of provisioning failure.
    :vartype error_message: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "statuses": {"readonly": True},
        "repository_public_key": {"readonly": True},
        "last_source_synced_commit_id": {"readonly": True},
        "last_source_synced_at": {"readonly": True},
        "compliance_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "scope": {"key": "properties.scope", "type": "str"},
        "namespace": {"key": "properties.namespace", "type": "str"},
        "source_kind": {"key": "properties.sourceKind", "type": "str"},
        "suspend": {"key": "properties.suspend", "type": "bool"},
        "git_repository": {"key": "properties.gitRepository", "type": "GitRepositoryDefinition"},
        "kustomizations": {"key": "properties.kustomizations", "type": "{KustomizationDefinition}"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
        "statuses": {"key": "properties.statuses", "type": "[ObjectStatusDefinition]"},
        "repository_public_key": {"key": "properties.repositoryPublicKey", "type": "str"},
        "last_source_synced_commit_id": {"key": "properties.lastSourceSyncedCommitId", "type": "str"},
        "last_source_synced_at": {"key": "properties.lastSourceSyncedAt", "type": "iso-8601"},
        "compliance_state": {"key": "properties.complianceState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        scope: Union[str, "_models.ScopeType"] = "cluster",
        namespace: str = "default",
        source_kind: Optional[Union[str, "_models.SourceKindType"]] = None,
        suspend: bool = False,
        git_repository: Optional["_models.GitRepositoryDefinition"] = None,
        kustomizations: Optional[Dict[str, "_models.KustomizationDefinition"]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Scope at which the operator will be installed. Known values are: "cluster" and
         "namespace".
        :paramtype scope: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ScopeType
        :keyword namespace: The namespace to which this configuration is installed to. Maximum of 253
         lower case alphanumeric characters, hyphen and period only.
        :paramtype namespace: str
        :keyword source_kind: Source Kind to pull the configuration data from. "GitRepository"
        :paramtype source_kind: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SourceKindType
        :keyword suspend: Whether this configuration should suspend its reconciliation of its
         kustomizations and sources.
        :paramtype suspend: bool
        :keyword git_repository: Parameters to reconcile to the GitRepository source kind type.
        :paramtype git_repository:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.GitRepositoryDefinition
        :keyword kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
         source type on the cluster.
        :paramtype kustomizations: dict[str,
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.KustomizationDefinition]
        :keyword configuration_protected_settings: Key-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.scope = scope
        self.namespace = namespace
        self.source_kind = source_kind
        self.suspend = suspend
        self.git_repository = git_repository
        self.kustomizations = kustomizations
        self.configuration_protected_settings = configuration_protected_settings
        self.statuses = None
        self.repository_public_key = None
        self.last_source_synced_commit_id = None
        self.last_source_synced_at = None
        self.compliance_state = None
        self.provisioning_state = None
        self.error_message = None


class FluxConfigurationPatch(_serialization.Model):
    """The Flux Configuration Patch Request object.

    :ivar source_kind: Source Kind to pull the configuration data from. "GitRepository"
    :vartype source_kind: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SourceKindType
    :ivar suspend: Whether this configuration should suspend its reconciliation of its
     kustomizations and sources.
    :vartype suspend: bool
    :ivar git_repository: Parameters to reconcile to the GitRepository source kind type.
    :vartype git_repository:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.GitRepositoryDefinition
    :ivar kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
     source type on the cluster.
    :vartype kustomizations: dict[str,
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.KustomizationDefinition]
    :ivar configuration_protected_settings: Key-value pairs of protected configuration settings for
     the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    """

    _attribute_map = {
        "source_kind": {"key": "properties.sourceKind", "type": "str"},
        "suspend": {"key": "properties.suspend", "type": "bool"},
        "git_repository": {"key": "properties.gitRepository", "type": "GitRepositoryDefinition"},
        "kustomizations": {"key": "properties.kustomizations", "type": "{KustomizationDefinition}"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        source_kind: Optional[Union[str, "_models.SourceKindType"]] = None,
        suspend: bool = False,
        git_repository: Optional["_models.GitRepositoryDefinition"] = None,
        kustomizations: Optional[Dict[str, "_models.KustomizationDefinition"]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_kind: Source Kind to pull the configuration data from. "GitRepository"
        :paramtype source_kind: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SourceKindType
        :keyword suspend: Whether this configuration should suspend its reconciliation of its
         kustomizations and sources.
        :paramtype suspend: bool
        :keyword git_repository: Parameters to reconcile to the GitRepository source kind type.
        :paramtype git_repository:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.GitRepositoryDefinition
        :keyword kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
         source type on the cluster.
        :paramtype kustomizations: dict[str,
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.KustomizationDefinition]
        :keyword configuration_protected_settings: Key-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        """
        super().__init__(**kwargs)
        self.source_kind = source_kind
        self.suspend = suspend
        self.git_repository = git_repository
        self.kustomizations = kustomizations
        self.configuration_protected_settings = configuration_protected_settings


class FluxConfigurationsList(_serialization.Model):
    """Result of the request to list Flux Configurations.  It contains a list of FluxConfiguration
    objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Flux Configurations within a Kubernetes cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.FluxConfiguration]
    :ivar next_link: URL to get the next set of configuration objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FluxConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class GitRepositoryDefinition(_serialization.Model):
    """Parameters to reconcile to the GitRepository source kind type.

    :ivar url: The URL to sync for the flux configuration git repository.
    :vartype url: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository
     source with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
     repository source with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar repository_ref: The source reference for the GitRepository object.
    :vartype repository_ref:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.RepositoryRefDefinition
    :ivar ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required to
     access private git repositories over SSH.
    :vartype ssh_known_hosts: str
    :ivar https_user: Base64-encoded HTTPS username used to access private git repositories over
     HTTPS.
    :vartype https_user: str
    :ivar https_ca_file: Base64-encoded HTTPS certificate authority contents used to access git
     private git repositories over HTTPS.
    :vartype https_ca_file: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "repository_ref": {"key": "repositoryRef", "type": "RepositoryRefDefinition"},
        "ssh_known_hosts": {"key": "sshKnownHosts", "type": "str"},
        "https_user": {"key": "httpsUser", "type": "str"},
        "https_ca_file": {"key": "httpsCAFile", "type": "str"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        timeout_in_seconds: int = 600,
        sync_interval_in_seconds: int = 600,
        repository_ref: Optional["_models.RepositoryRefDefinition"] = None,
        ssh_known_hosts: Optional[str] = None,
        https_user: Optional[str] = None,
        https_ca_file: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration git repository.
        :paramtype url: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster git
         repository source with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
         repository source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword repository_ref: The source reference for the GitRepository object.
        :paramtype repository_ref:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.RepositoryRefDefinition
        :keyword ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required
         to access private git repositories over SSH.
        :paramtype ssh_known_hosts: str
        :keyword https_user: Base64-encoded HTTPS username used to access private git repositories over
         HTTPS.
        :paramtype https_user: str
        :keyword https_ca_file: Base64-encoded HTTPS certificate authority contents used to access git
         private git repositories over HTTPS.
        :paramtype https_ca_file: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super().__init__(**kwargs)
        self.url = url
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.repository_ref = repository_ref
        self.ssh_known_hosts = ssh_known_hosts
        self.https_user = https_user
        self.https_ca_file = https_ca_file
        self.local_auth_ref = local_auth_ref


class HelmOperatorProperties(_serialization.Model):
    """Properties for Helm operator.

    :ivar chart_version: Version of the operator Helm chart.
    :vartype chart_version: str
    :ivar chart_values: Values override for the operator Helm chart.
    :vartype chart_values: str
    """

    _attribute_map = {
        "chart_version": {"key": "chartVersion", "type": "str"},
        "chart_values": {"key": "chartValues", "type": "str"},
    }

    def __init__(
        self, *, chart_version: Optional[str] = None, chart_values: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword chart_version: Version of the operator Helm chart.
        :paramtype chart_version: str
        :keyword chart_values: Values override for the operator Helm chart.
        :paramtype chart_values: str
        """
        super().__init__(**kwargs)
        self.chart_version = chart_version
        self.chart_values = chart_values


class HelmReleasePropertiesDefinition(_serialization.Model):
    """HelmReleasePropertiesDefinition.

    :ivar last_revision_applied: The revision number of the last released object change.
    :vartype last_revision_applied: int
    :ivar helm_chart_ref: The reference to the HelmChart object used as the source to this
     HelmRelease.
    :vartype helm_chart_ref:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ObjectReferenceDefinition
    :ivar failure_count: Total number of times that the HelmRelease failed to install or upgrade.
    :vartype failure_count: int
    :ivar install_failure_count: Number of times that the HelmRelease failed to install.
    :vartype install_failure_count: int
    :ivar upgrade_failure_count: Number of times that the HelmRelease failed to upgrade.
    :vartype upgrade_failure_count: int
    """

    _attribute_map = {
        "last_revision_applied": {"key": "lastRevisionApplied", "type": "int"},
        "helm_chart_ref": {"key": "helmChartRef", "type": "ObjectReferenceDefinition"},
        "failure_count": {"key": "failureCount", "type": "int"},
        "install_failure_count": {"key": "installFailureCount", "type": "int"},
        "upgrade_failure_count": {"key": "upgradeFailureCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        last_revision_applied: Optional[int] = None,
        helm_chart_ref: Optional["_models.ObjectReferenceDefinition"] = None,
        failure_count: Optional[int] = None,
        install_failure_count: Optional[int] = None,
        upgrade_failure_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_revision_applied: The revision number of the last released object change.
        :paramtype last_revision_applied: int
        :keyword helm_chart_ref: The reference to the HelmChart object used as the source to this
         HelmRelease.
        :paramtype helm_chart_ref:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ObjectReferenceDefinition
        :keyword failure_count: Total number of times that the HelmRelease failed to install or
         upgrade.
        :paramtype failure_count: int
        :keyword install_failure_count: Number of times that the HelmRelease failed to install.
        :paramtype install_failure_count: int
        :keyword upgrade_failure_count: Number of times that the HelmRelease failed to upgrade.
        :paramtype upgrade_failure_count: int
        """
        super().__init__(**kwargs)
        self.last_revision_applied = last_revision_applied
        self.helm_chart_ref = helm_chart_ref
        self.failure_count = failure_count
        self.install_failure_count = install_failure_count
        self.upgrade_failure_count = upgrade_failure_count


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Literal["SystemAssigned"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The identity type. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class KustomizationDefinition(_serialization.Model):
    """The Kustomization defining how to reconcile the artifact pulled by the source type on the
    cluster.

    :ivar path: The path in the source reference to reconcile on the cluster.
    :vartype path: str
    :ivar depends_on: Specifies other Kustomizations that this Kustomization depends on. This
     Kustomization will not reconcile until all dependencies have completed their reconciliation.
    :vartype depends_on:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.DependsOnDefinition]
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
     cluster.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster.
    :vartype sync_interval_in_seconds: int
    :ivar retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster in the event of failure on reconciliation.
    :vartype retry_interval_in_seconds: int
    :ivar prune: Enable/disable garbage collections of Kubernetes objects created by this
     Kustomization.
    :vartype prune: bool
    :ivar validation: Specify whether to validate the Kubernetes objects referenced in the
     Kustomization before applying them to the cluster. Known values are: "none", "client", and
     "server".
    :vartype validation: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.KustomizationValidationType
    :ivar force: Enable/disable re-creating Kubernetes resources on the cluster when patching fails
     due to an immutable field change.
    :vartype force: bool
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[DependsOnDefinition]"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "retry_interval_in_seconds": {"key": "retryIntervalInSeconds", "type": "int"},
        "prune": {"key": "prune", "type": "bool"},
        "validation": {"key": "validation", "type": "str"},
        "force": {"key": "force", "type": "bool"},
    }

    def __init__(
        self,
        *,
        path: str = "",
        depends_on: Optional[List["_models.DependsOnDefinition"]] = None,
        timeout_in_seconds: int = 600,
        sync_interval_in_seconds: int = 600,
        retry_interval_in_seconds: Optional[int] = None,
        prune: bool = False,
        validation: Union[str, "_models.KustomizationValidationType"] = "none",
        force: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path in the source reference to reconcile on the cluster.
        :paramtype path: str
        :keyword depends_on: Specifies other Kustomizations that this Kustomization depends on. This
         Kustomization will not reconcile until all dependencies have completed their reconciliation.
        :paramtype depends_on:
         list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.DependsOnDefinition]
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
         cluster.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster.
        :paramtype sync_interval_in_seconds: int
        :keyword retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster in the event of failure on reconciliation.
        :paramtype retry_interval_in_seconds: int
        :keyword prune: Enable/disable garbage collections of Kubernetes objects created by this
         Kustomization.
        :paramtype prune: bool
        :keyword validation: Specify whether to validate the Kubernetes objects referenced in the
         Kustomization before applying them to the cluster. Known values are: "none", "client", and
         "server".
        :paramtype validation: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.KustomizationValidationType
        :keyword force: Enable/disable re-creating Kubernetes resources on the cluster when patching
         fails due to an immutable field change.
        :paramtype force: bool
        """
        super().__init__(**kwargs)
        self.path = path
        self.depends_on = depends_on
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.prune = prune
        self.validation = validation
        self.force = force


class ObjectReferenceDefinition(_serialization.Model):
    """Object reference to a Kubernetes object on a cluster.

    :ivar name: Name of the object.
    :vartype name: str
    :ivar namespace: Namespace of the object.
    :vartype namespace: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, namespace: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the object.
        :paramtype name: str
        :keyword namespace: Namespace of the object.
        :paramtype namespace: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace


class ObjectStatusConditionDefinition(_serialization.Model):
    """Status condition of Kubernetes object.

    :ivar last_transition_time: Last time this status condition has changed.
    :vartype last_transition_time: ~datetime.datetime
    :ivar message: A more verbose description of the object status condition.
    :vartype message: str
    :ivar reason: Reason for the specified status condition type status.
    :vartype reason: str
    :ivar status: Status of the Kubernetes object condition type.
    :vartype status: str
    :ivar type: Object status condition type for this object.
    :vartype type: str
    """

    _attribute_map = {
        "last_transition_time": {"key": "lastTransitionTime", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_transition_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        reason: Optional[str] = None,
        status: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_transition_time: Last time this status condition has changed.
        :paramtype last_transition_time: ~datetime.datetime
        :keyword message: A more verbose description of the object status condition.
        :paramtype message: str
        :keyword reason: Reason for the specified status condition type status.
        :paramtype reason: str
        :keyword status: Status of the Kubernetes object condition type.
        :paramtype status: str
        :keyword type: Object status condition type for this object.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.last_transition_time = last_transition_time
        self.message = message
        self.reason = reason
        self.status = status
        self.type = type


class ObjectStatusDefinition(_serialization.Model):
    """Statuses of objects deployed by the user-specified kustomizations from the git repository.

    :ivar name: Name of the applied object.
    :vartype name: str
    :ivar namespace: Namespace of the applied object.
    :vartype namespace: str
    :ivar kind: Kind of the applied object.
    :vartype kind: str
    :ivar compliance_state: Compliance state of the applied object showing whether the applied
     object has come into a ready state on the cluster. Known values are: "Compliant",
     "Non-Compliant", "Pending", "Suspended", and "Unknown".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.FluxComplianceState
    :ivar applied_by: Object reference to the Kustomization that applied this object.
    :vartype applied_by:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ObjectReferenceDefinition
    :ivar status_conditions: List of Kubernetes object status conditions present on the cluster.
    :vartype status_conditions:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ObjectStatusConditionDefinition]
    :ivar helm_release_properties: Additional properties that are provided from objects of the
     HelmRelease kind.
    :vartype helm_release_properties:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.HelmReleasePropertiesDefinition
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "compliance_state": {"key": "complianceState", "type": "str"},
        "applied_by": {"key": "appliedBy", "type": "ObjectReferenceDefinition"},
        "status_conditions": {"key": "statusConditions", "type": "[ObjectStatusConditionDefinition]"},
        "helm_release_properties": {"key": "helmReleaseProperties", "type": "HelmReleasePropertiesDefinition"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        namespace: Optional[str] = None,
        kind: Optional[str] = None,
        compliance_state: Union[str, "_models.FluxComplianceState"] = "Unknown",
        applied_by: Optional["_models.ObjectReferenceDefinition"] = None,
        status_conditions: Optional[List["_models.ObjectStatusConditionDefinition"]] = None,
        helm_release_properties: Optional["_models.HelmReleasePropertiesDefinition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the applied object.
        :paramtype name: str
        :keyword namespace: Namespace of the applied object.
        :paramtype namespace: str
        :keyword kind: Kind of the applied object.
        :paramtype kind: str
        :keyword compliance_state: Compliance state of the applied object showing whether the applied
         object has come into a ready state on the cluster. Known values are: "Compliant",
         "Non-Compliant", "Pending", "Suspended", and "Unknown".
        :paramtype compliance_state: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.FluxComplianceState
        :keyword applied_by: Object reference to the Kustomization that applied this object.
        :paramtype applied_by:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ObjectReferenceDefinition
        :keyword status_conditions: List of Kubernetes object status conditions present on the cluster.
        :paramtype status_conditions:
         list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ObjectStatusConditionDefinition]
        :keyword helm_release_properties: Additional properties that are provided from objects of the
         HelmRelease kind.
        :paramtype helm_release_properties:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.HelmReleasePropertiesDefinition
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.kind = kind
        self.compliance_state = compliance_state
        self.applied_by = applied_by
        self.status_conditions = status_conditions
        self.helm_release_properties = helm_release_properties


class OperationStatusList(_serialization.Model):
    """The async operations in progress, in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of async operations in progress, in the cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.OperationStatusResult]
    :ivar next_link: URL to get the next set of Operation Result objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationStatusResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar properties: Additional information, if available.
    :vartype properties: dict[str, str]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword properties: Additional information, if available.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = None


class PatchExtension(_serialization.Model):
    """The Extension Patch Request object.

    :ivar auto_upgrade_minor_version: Flag to note if this extension participates in auto upgrade
     of minor version, or not.
    :vartype auto_upgrade_minor_version: bool
    :ivar release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable,
     Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :vartype release_train: str
    :ivar version: Version of the extension for this extension, if it is 'pinned' to a specific
     version. autoUpgradeMinorVersion must be 'false'.
    :vartype version: str
    :ivar configuration_settings: Configuration settings, as name-value pairs for configuring this
     extension.
    :vartype configuration_settings: dict[str, str]
    :ivar configuration_protected_settings: Configuration settings that are sensitive, as
     name-value pairs for configuring this extension.
    :vartype configuration_protected_settings: dict[str, str]
    """

    _attribute_map = {
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "release_train": {"key": "properties.releaseTrain", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "configuration_settings": {"key": "properties.configurationSettings", "type": "{str}"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        auto_upgrade_minor_version: bool = True,
        release_train: str = "Stable",
        version: Optional[str] = None,
        configuration_settings: Optional[Dict[str, str]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_upgrade_minor_version: Flag to note if this extension participates in auto
         upgrade of minor version, or not.
        :paramtype auto_upgrade_minor_version: bool
        :keyword release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g.
         Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        :paramtype release_train: str
        :keyword version: Version of the extension for this extension, if it is 'pinned' to a specific
         version. autoUpgradeMinorVersion must be 'false'.
        :paramtype version: str
        :keyword configuration_settings: Configuration settings, as name-value pairs for configuring
         this extension.
        :paramtype configuration_settings: dict[str, str]
        :keyword configuration_protected_settings: Configuration settings that are sensitive, as
         name-value pairs for configuring this extension.
        :paramtype configuration_protected_settings: dict[str, str]
        """
        super().__init__(**kwargs)
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version
        self.configuration_settings = configuration_settings
        self.configuration_protected_settings = configuration_protected_settings


class RepositoryRefDefinition(_serialization.Model):
    """The source reference for the GitRepository object.

    :ivar branch: The git repository branch name to checkout.
    :vartype branch: str
    :ivar tag: The git repository tag name to checkout. This takes precedence over branch.
    :vartype tag: str
    :ivar semver: The semver range used to match against git repository tags. This takes precedence
     over tag.
    :vartype semver: str
    :ivar commit: The commit SHA to checkout. This value must be combined with the branch name to
     be valid. This takes precedence over semver.
    :vartype commit: str
    """

    _attribute_map = {
        "branch": {"key": "branch", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "semver": {"key": "semver", "type": "str"},
        "commit": {"key": "commit", "type": "str"},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        tag: Optional[str] = None,
        semver: Optional[str] = None,
        commit: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword branch: The git repository branch name to checkout.
        :paramtype branch: str
        :keyword tag: The git repository tag name to checkout. This takes precedence over branch.
        :paramtype tag: str
        :keyword semver: The semver range used to match against git repository tags. This takes
         precedence over tag.
        :paramtype semver: str
        :keyword commit: The commit SHA to checkout. This value must be combined with the branch name
         to be valid. This takes precedence over semver.
        :paramtype commit: str
        """
        super().__init__(**kwargs)
        self.branch = branch
        self.tag = tag
        self.semver = semver
        self.commit = commit


class ResourceProviderOperation(_serialization.Model):
    """Supported operation of this resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name, in format of {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ResourceProviderOperationDisplay
    :ivar is_data_action: The flag that indicates whether the operation applies to data plane.
    :vartype is_data_action: bool
    :ivar origin: Origin of the operation.
    :vartype origin: str
    """

    _validation = {
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "ResourceProviderOperationDisplay"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.ResourceProviderOperationDisplay"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name, in format of {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ResourceProviderOperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = None
        self.origin = None


class ResourceProviderOperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Resource provider: Microsoft KubernetesConfiguration.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of this operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Resource provider: Microsoft KubernetesConfiguration.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of this operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceProviderOperationList(_serialization.Model):
    """Result of the request to list operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by this resource provider.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ResourceProviderOperation]
    :ivar next_link: URL to the next set of results, if any.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceProviderOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ResourceProviderOperation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of operations supported by this resource provider.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ResourceProviderOperation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Scope(_serialization.Model):
    """Scope of the extension. It can be either Cluster or Namespace; but not both.

    :ivar cluster: Specifies that the scope of the extension is Cluster.
    :vartype cluster: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ScopeCluster
    :ivar namespace: Specifies that the scope of the extension is Namespace.
    :vartype namespace:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ScopeNamespace
    """

    _attribute_map = {
        "cluster": {"key": "cluster", "type": "ScopeCluster"},
        "namespace": {"key": "namespace", "type": "ScopeNamespace"},
    }

    def __init__(
        self,
        *,
        cluster: Optional["_models.ScopeCluster"] = None,
        namespace: Optional["_models.ScopeNamespace"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster: Specifies that the scope of the extension is Cluster.
        :paramtype cluster: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ScopeCluster
        :keyword namespace: Specifies that the scope of the extension is Namespace.
        :paramtype namespace:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ScopeNamespace
        """
        super().__init__(**kwargs)
        self.cluster = cluster
        self.namespace = namespace


class ScopeCluster(_serialization.Model):
    """Specifies that the scope of the extension is Cluster.

    :ivar release_namespace: Namespace where the extension Release must be placed, for a Cluster
     scoped extension.  If this namespace does not exist, it will be created.
    :vartype release_namespace: str
    """

    _attribute_map = {
        "release_namespace": {"key": "releaseNamespace", "type": "str"},
    }

    def __init__(self, *, release_namespace: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword release_namespace: Namespace where the extension Release must be placed, for a Cluster
         scoped extension.  If this namespace does not exist, it will be created.
        :paramtype release_namespace: str
        """
        super().__init__(**kwargs)
        self.release_namespace = release_namespace


class ScopeNamespace(_serialization.Model):
    """Specifies that the scope of the extension is Namespace.

    :ivar target_namespace: Namespace where the extension will be created for an Namespace scoped
     extension.  If this namespace does not exist, it will be created.
    :vartype target_namespace: str
    """

    _attribute_map = {
        "target_namespace": {"key": "targetNamespace", "type": "str"},
    }

    def __init__(self, *, target_namespace: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword target_namespace: Namespace where the extension will be created for an Namespace
         scoped extension.  If this namespace does not exist, it will be created.
        :paramtype target_namespace: str
        """
        super().__init__(**kwargs)
        self.target_namespace = target_namespace


class SourceControlConfiguration(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The SourceControl Configuration object returned in Get & Put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SystemData
    :ivar repository_url: Url of the SourceControl Repository.
    :vartype repository_url: str
    :ivar operator_namespace: The namespace to which this operator is installed to. Maximum of 253
     lower case alphanumeric characters, hyphen and period only.
    :vartype operator_namespace: str
    :ivar operator_instance_name: Instance name of the operator - identifying the specific
     configuration.
    :vartype operator_instance_name: str
    :ivar operator_type: Type of the operator. "Flux"
    :vartype operator_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.OperatorType
    :ivar operator_params: Any Parameters for the Operator instance in string format.
    :vartype operator_params: str
    :ivar configuration_protected_settings: Name-value pairs of protected configuration settings
     for the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar operator_scope: Scope at which the operator will be installed. Known values are:
     "cluster" and "namespace".
    :vartype operator_scope: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.OperatorScopeType
    :ivar repository_public_key: Public Key associated with this SourceControl configuration
     (either generated within the cluster or provided by the user).
    :vartype repository_public_key: str
    :ivar ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH keys
     required to access private Git instances.
    :vartype ssh_known_hosts_contents: str
    :ivar enable_helm_operator: Option to enable Helm Operator for this git configuration.
    :vartype enable_helm_operator: bool
    :ivar helm_operator_properties: Properties for Helm operator.
    :vartype helm_operator_properties:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.HelmOperatorProperties
    :ivar provisioning_state: The provisioning state of the resource provider. Known values are:
     "Accepted", "Deleting", "Running", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ProvisioningStateType
    :ivar compliance_status: Compliance Status of the Configuration.
    :vartype compliance_status:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ComplianceStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "repository_public_key": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "compliance_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "repository_url": {"key": "properties.repositoryUrl", "type": "str"},
        "operator_namespace": {"key": "properties.operatorNamespace", "type": "str"},
        "operator_instance_name": {"key": "properties.operatorInstanceName", "type": "str"},
        "operator_type": {"key": "properties.operatorType", "type": "str"},
        "operator_params": {"key": "properties.operatorParams", "type": "str"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
        "operator_scope": {"key": "properties.operatorScope", "type": "str"},
        "repository_public_key": {"key": "properties.repositoryPublicKey", "type": "str"},
        "ssh_known_hosts_contents": {"key": "properties.sshKnownHostsContents", "type": "str"},
        "enable_helm_operator": {"key": "properties.enableHelmOperator", "type": "bool"},
        "helm_operator_properties": {"key": "properties.helmOperatorProperties", "type": "HelmOperatorProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "compliance_status": {"key": "properties.complianceStatus", "type": "ComplianceStatus"},
    }

    def __init__(
        self,
        *,
        repository_url: Optional[str] = None,
        operator_namespace: str = "default",
        operator_instance_name: Optional[str] = None,
        operator_type: Optional[Union[str, "_models.OperatorType"]] = None,
        operator_params: Optional[str] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        operator_scope: Union[str, "_models.OperatorScopeType"] = "cluster",
        ssh_known_hosts_contents: Optional[str] = None,
        enable_helm_operator: Optional[bool] = None,
        helm_operator_properties: Optional["_models.HelmOperatorProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword repository_url: Url of the SourceControl Repository.
        :paramtype repository_url: str
        :keyword operator_namespace: The namespace to which this operator is installed to. Maximum of
         253 lower case alphanumeric characters, hyphen and period only.
        :paramtype operator_namespace: str
        :keyword operator_instance_name: Instance name of the operator - identifying the specific
         configuration.
        :paramtype operator_instance_name: str
        :keyword operator_type: Type of the operator. "Flux"
        :paramtype operator_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.OperatorType
        :keyword operator_params: Any Parameters for the Operator instance in string format.
        :paramtype operator_params: str
        :keyword configuration_protected_settings: Name-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword operator_scope: Scope at which the operator will be installed. Known values are:
         "cluster" and "namespace".
        :paramtype operator_scope: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.OperatorScopeType
        :keyword ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH
         keys required to access private Git instances.
        :paramtype ssh_known_hosts_contents: str
        :keyword enable_helm_operator: Option to enable Helm Operator for this git configuration.
        :paramtype enable_helm_operator: bool
        :keyword helm_operator_properties: Properties for Helm operator.
        :paramtype helm_operator_properties:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.HelmOperatorProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.repository_url = repository_url
        self.operator_namespace = operator_namespace
        self.operator_instance_name = operator_instance_name
        self.operator_type = operator_type
        self.operator_params = operator_params
        self.configuration_protected_settings = configuration_protected_settings
        self.operator_scope = operator_scope
        self.repository_public_key = None
        self.ssh_known_hosts_contents = ssh_known_hosts_contents
        self.enable_helm_operator = enable_helm_operator
        self.helm_operator_properties = helm_operator_properties
        self.provisioning_state = None
        self.compliance_status = None


class SourceControlConfigurationList(_serialization.Model):
    """Result of the request to list Source Control Configurations.  It contains a list of
    SourceControlConfiguration objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Source Control Configurations within a Kubernetes cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.SourceControlConfiguration]
    :ivar next_link: URL to get the next set of configuration objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SourceControlConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SupportedScopes(_serialization.Model):
    """Extension scopes.

    :ivar default_scope: Default extension scopes: cluster or namespace.
    :vartype default_scope: str
    :ivar cluster_scope_settings: Scope settings.
    :vartype cluster_scope_settings:
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ClusterScopeSettings
    """

    _attribute_map = {
        "default_scope": {"key": "defaultScope", "type": "str"},
        "cluster_scope_settings": {"key": "clusterScopeSettings", "type": "ClusterScopeSettings"},
    }

    def __init__(
        self,
        *,
        default_scope: Optional[str] = None,
        cluster_scope_settings: Optional["_models.ClusterScopeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_scope: Default extension scopes: cluster or namespace.
        :paramtype default_scope: str
        :keyword cluster_scope_settings: Scope settings.
        :paramtype cluster_scope_settings:
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.ClusterScopeSettings
        """
        super().__init__(**kwargs)
        self.default_scope = default_scope
        self.cluster_scope_settings = cluster_scope_settings


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2021_11_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
