/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Disassembler {
    private IndentPrintWriter ipw = new IndentPrintWriter(System.out);
    private boolean verbose = false;
    private File sourceDirectory = new File(".");
    private static final String[] instructions = new String[]{"50  aaload", "83  aastore", "1   aconst_null", "25  aload         localvariablearrayindex1", "42  aload_0       localvariablearrayindex_0", "43  aload_1       localvariablearrayindex_1", "44  aload_2       localvariablearrayindex_2", "45  aload_3       localvariablearrayindex_3", "189 anewarray     constantpoolindex2", "176 areturn", "190 arraylength", "58  astore        localvariablearrayindex1", "75  astore_0      localvariablearrayindex_0", "76  astore_1      localvariablearrayindex_1", "77  astore_2      localvariablearrayindex_2", "78  astore_3      localvariablearrayindex_3", "191 athrow", "51  baload", "84  bastore", "16  bipush        signedbyte", "52  caload", "85  castore", "192 checkcast     constantpoolindex2", "144 d2f", "142 d2i", "143 d2l", "99  dadd", "49  daload", "82  dastore", "152 dcmpg", "151 dcmpl", "14  dconst_0", "15  dconst_1", "111 ddiv", "24  dload         localvariablearrayindex1", "38  dload_0       localvariablearrayindex_0", "39  dload_1       localvariablearrayindex_1", "40  dload_2       localvariablearrayindex_2", "41  dload_3       localvariablearrayindex_3", "107 dmul", "119 dneg", "115 drem", "175 dreturn", "57  dstore        localvariablearrayindex1", "71  dstore_0      localvariablearrayindex_0", "72  dstore_1      localvariablearrayindex_1", "73  dstore_2      localvariablearrayindex_2", "74  dstore_3      localvariablearrayindex_3", "103 dsub", "89  dup", "90  dup_x1", "91  dup_x2", "92  dup2", "93  dup2_x1", "94  dup2_x2", "141 f2d", "139 f2i", "140 f2l", "98  fadd", "48  faload", "81  fastore", "150 fcmpg", "149 fcmpl", "11  fconst_0", "12  fconst_1", "13  fconst_2", "110 fdiv", "23  fload         localvariablearrayindex1", "34  fload_0       localvariablearrayindex_0", "35  fload_1       localvariablearrayindex_1", "36  fload_2       localvariablearrayindex_2", "37  fload_3       localvariablearrayindex_3", "106 fmul", "118 fneg", "114 frem", "174 freturn", "56  fstore        localvariablearrayindex1", "67  fstore_0      localvariablearrayindex_0", "68  fstore_1      localvariablearrayindex_1", "69  fstore_2      localvariablearrayindex_2", "70  fstore_3      localvariablearrayindex_3", "102 fsub", "180 getfield      constantpoolindex2", "178 getstatic     constantpoolindex2", "167 goto          branchoffset2", "200 goto_w        branchoffset4", "145 i2b", "146 i2c", "135 i2d", "134 i2f", "133 i2l", "147 i2s", "96  iadd", "46  iaload", "126 iand", "79  iastore", "2   iconst_m1", "3   iconst_0", "4   iconst_1", "5   iconst_2", "6   iconst_3", "7   iconst_4", "8   iconst_5", "108 idiv", "165 if_acmpeq", "166 if_acmpne", "159 if_icmpeq     branchoffset2", "160 if_icmpne     branchoffset2", "161 if_icmplt     branchoffset2", "162 if_icmpge     branchoffset2", "163 if_icmpgt     branchoffset2", "164 if_icmple     branchoffset2", "153 ifeq          branchoffset2", "154 ifne          branchoffset2", "155 iflt          branchoffset2", "156 ifge          branchoffset2", "157 ifgt          branchoffset2", "158 ifle          branchoffset2", "199 ifnonnull     branchoffset2", "198 ifnull        branchoffset2", "132 iinc          localvariablearrayindex1 signedbyte", "21  iload         localvariablearrayindex1", "26  iload_0       localvariablearrayindex_0", "27  iload_1       localvariablearrayindex_1", "28  iload_2       localvariablearrayindex_2", "29  iload_3       localvariablearrayindex_3", "104 imul", "116 ineg", "193 instanceof      constantpoolindex2", "185 invokeinterface constantpoolindex2 signedbyte signedbyte", "183 invokespecial   constantpoolindex2", "184 invokestatic    constantpoolindex2", "182 invokevirtual   constantpoolindex2", "128 ior", "112 irem", "172 ireturn", "120 ishl", "122 ishr", "54  istore          localvariablearrayindex1", "59  istore_0        localvariablearrayindex_0", "60  istore_1        localvariablearrayindex_1", "61  istore_2        localvariablearrayindex_2", "62  istore_3        localvariablearrayindex_3", "100 isub", "124 iushr", "130 ixor", "168 jsr             branchoffset2", "201 jsr_w           branchoffset4", "138 l2d", "137 l2f", "136 l2i", "97  ladd", "47  laload", "127 land", "80  lastore", "148 lcmp", "9   lconst_0", "10  lconst_1", "18  ldc           constantpoolindex1", "19  ldc_w         constantpoolindex2", "20  ldc2_w        constantpoolindex2", "109 ldiv", "22  lload         localvariablearrayindex1", "30  lload_0       localvariablearrayindex_0", "31  lload_1       localvariablearrayindex_1", "32  lload_2       localvariablearrayindex_2", "33  lload_3       localvariablearrayindex_3", "105 lmul", "117 lneg", "171 lookupswitch  lookupswitch", "129 lor", "113 lrem", "173 lreturn", "121 lshl", "123 lshr", "55  lstore        localvariablearrayindex1", "63  lstore_0      localvariablearrayindex_0", "64  lstore_1      localvariablearrayindex_1", "65  lstore_2      localvariablearrayindex_2", "66  lstore_3      localvariablearrayindex_3", "101 lsub", "125 lushr", "131 lxor", "194 monitorenter", "195 monitorexit", "197 multianewarray constantpoolindex2 unsignedbyte", "187 new           constantpoolindex2", "188 newarray      atype", "0   nop", "87  pop", "88  pop2", "181 putfield      constantpoolindex2", "179 putstatic     constantpoolindex2", "169 ret           localvariablearrayindex1", "177 return", "53  saload", "86  sastore", "17  sipush        signedshort", "95  swap", "170 tableswitch   tableswitch", "196 wide          wide"};
    private static final String[] wideInstructions = new String[]{"21  iload         localvariablearrayindex2", "23  fload         localvariablearrayindex2", "25  aload         localvariablearrayindex2", "22  lload         localvariablearrayindex2", "24  dload         localvariablearrayindex2", "54  istore        localvariablearrayindex2", "56  fstore        localvariablearrayindex2", "58  astore        localvariablearrayindex2", "55  lstore        localvariablearrayindex2", "57  dstore        localvariablearrayindex2", "169 ret           localvariablearrayindex2", "132 iinc          localvariablearrayindex2 signedshort"};
    private static final Instruction[] opcodeToInstruction = new Instruction[256];
    private static final Instruction[] opcodeToWideInstruction = new Instruction[256];
    private ConstantPoolInfo[] constantPool = null;
    private static final String[] PRIMITIVES;

    static {
        Disassembler.compileInstructions(instructions, opcodeToInstruction);
        Disassembler.compileInstructions(wideInstructions, opcodeToWideInstruction);
        PRIMITIVES = new String[]{"byte", "char", "double", "float", "int", "long", "short", "boolean"};
    }

    private static void compileInstructions(String[] stringArray, Instruction[] instructionArray) {
        int n = 0;
        while (n < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n]);
            String string = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string);
            String string2 = stringTokenizer.nextToken();
            Operand[] operandArray = null;
            if (stringTokenizer.hasMoreTokens()) {
                ArrayList<19> arrayList = new ArrayList<19>();
                while (stringTokenizer.hasMoreTokens()) {
                    Operand operand;
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equals("constantpoolindex1")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                short s = (short)(0xFF & dataInputStream.readByte());
                                disassembler.printConstantPoolEntry(s);
                            }
                        };
                    } else if (string3.equals("constantpoolindex2")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                disassembler.printConstantPoolEntry(dataInputStream.readShort());
                            }
                        };
                    } else if (string3.equals("localvariablearrayindex1")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                short s = dataInputStream.readByte();
                                disassembler.print(s);
                                if (localVariableTableAttribute != null) {
                                    disassembler.print(" (" + localVariableTableAttribute.find(s, n + 2) + ")");
                                }
                            }
                        };
                    } else if (string3.equals("localvariablearrayindex2")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                short s = dataInputStream.readShort();
                                disassembler.print(s);
                                if (localVariableTableAttribute != null) {
                                    disassembler.print(" (" + localVariableTableAttribute.find(s, n + 3) + ")");
                                }
                            }
                        };
                    } else if (string3.startsWith("localvariablearrayindex_")) {
                        final short s = Short.parseShort(string3.substring(string3.length() - 1));
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                if (localVariableTableAttribute != null) {
                                    disassembler.print("(" + localVariableTableAttribute.find(s, n + 1) + ")");
                                }
                            }
                        };
                    } else if (string3.equals("branchoffset2")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                disassembler.print(n + dataInputStream.readShort());
                            }
                        };
                    } else if (string3.equals("branchoffset4")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                disassembler.print(n + dataInputStream.readInt());
                            }
                        };
                    } else if (string3.equals("signedbyte")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                disassembler.print(dataInputStream.readByte());
                            }
                        };
                    } else if (string3.equals("unsignedbyte")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                disassembler.print(0xFF & dataInputStream.readByte());
                            }
                        };
                    } else if (string3.equals("atype")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                byte by = dataInputStream.readByte();
                                disassembler.print(by == 4 ? "BOOLEAN" : (by == 5 ? "CHAR" : (by == 6 ? "FLOAT" : (by == 7 ? "DOUBLE" : (by == 8 ? "BYTE" : (by == 9 ? "SHORT" : (by == 10 ? "INT" : (by == 11 ? "LONG" : new Integer(0xFF & by).toString()))))))));
                            }
                        };
                    } else if (string3.equals("signedshort")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                disassembler.print(dataInputStream.readShort());
                            }
                        };
                    } else if (string3.equals("tableswitch")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                int n2 = 3 - n % 4;
                                int n3 = 0;
                                while (n3 < n2) {
                                    if (dataInputStream.readByte() != 0) {
                                        throw new RuntimeException("Non-zero pad byte in \"tableswitch\"");
                                    }
                                    ++n3;
                                }
                                disassembler.print("default => " + (n + dataInputStream.readInt()));
                                int n4 = dataInputStream.readInt();
                                int n5 = dataInputStream.readInt();
                                int n6 = n4;
                                while (n6 <= n5) {
                                    int n7 = dataInputStream.readInt();
                                    disassembler.print(", " + n6 + " => " + (n + n7));
                                    ++n6;
                                }
                            }
                        };
                    } else if (string3.equals("lookupswitch")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                int n2;
                                int n3 = 3 - n % 4;
                                int n4 = 0;
                                while (n4 < n3) {
                                    n2 = dataInputStream.readByte();
                                    if (n2 != 0) {
                                        disassembler.print("Padding byte #" + n4 + " is " + (n2 & 0xFF));
                                    }
                                    ++n4;
                                }
                                disassembler.print("default => " + (n + dataInputStream.readInt()));
                                n2 = dataInputStream.readInt();
                                int n5 = 0;
                                while (n5 < n2) {
                                    int n6 = dataInputStream.readInt();
                                    int n7 = dataInputStream.readInt();
                                    disassembler.print(", " + n6 + " => " + (n + n7));
                                    ++n5;
                                }
                            }
                        };
                    } else if (string3.equals("wide")) {
                        operand = new Operand(){

                            public void disasm(DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute, Disassembler disassembler) throws IOException {
                                int n2 = 0xFF & dataInputStream.readByte();
                                Instruction instruction = opcodeToWideInstruction[n2];
                                if (instruction == null) {
                                    throw new RuntimeException("Invalid opcode " + n2 + " after opcode WIDE");
                                }
                                disassembler.disasmInstruction(instruction, dataInputStream, n, localVariableTableAttribute);
                            }
                        };
                    } else {
                        throw new RuntimeException("Unknown operand \"" + string3 + "\"");
                    }
                    arrayList.add(operand);
                }
                operandArray = arrayList.toArray(new Operand[arrayList.size()]);
            }
            instructionArray[n2] = new Instruction(string2, operandArray);
            ++n;
        }
    }

    private static String decodeAccess(short s) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((s & 7) == 0) {
            stringBuffer.append("package ");
        }
        if ((s & 7) == 1) {
            stringBuffer.append("public ");
            s = (short)(s & 0xFFFFFFF8);
        }
        if ((s & 7) == 2) {
            stringBuffer.append("private ");
            s = (short)(s & 0xFFFFFFF8);
        }
        if ((s & 7) == 4) {
            stringBuffer.append("protected ");
            s = (short)(s & 0xFFFFFFF8);
        }
        if ((s & 8) != 0) {
            stringBuffer.append("static ");
            s = (short)(s & 0xFFFFFFF7);
        }
        if ((s & 0x10) != 0) {
            stringBuffer.append("final ");
            s = (short)(s & 0xFFFFFFEF);
        }
        if ((s & 0x20) != 0) {
            stringBuffer.append("super/synchronized ");
            s = (short)(s & 0xFFFFFFDF);
        }
        if ((s & 0x40) != 0) {
            stringBuffer.append("volatile ");
            s = (short)(s & 0xFFFFFFBF);
        }
        if ((s & 0x80) != 0) {
            stringBuffer.append("transient ");
            s = (short)(s & 0xFFFFFF7F);
        }
        if ((s & 0x100) != 0) {
            stringBuffer.append("native ");
            s = (short)(s & 0xFFFFFEFF);
        }
        if ((s & 0x200) != 0) {
            stringBuffer.append("interface ");
            s = (short)(s & 0xFFFFFDFF);
        }
        if ((s & 0x400) != 0) {
            stringBuffer.append("abstract ");
            s = (short)(s & 0xFFFFFBFF);
        }
        if ((s & 0x800) != 0) {
            stringBuffer.append("strict ");
            s = (short)(s & 0xFFFFF7FF);
        }
        if (s != 0) {
            stringBuffer.append("+ " + s + " ");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private static String decodeDescriptor(String string) {
        int n = 0;
        while (string.charAt(0) == '[') {
            ++n;
            string = string.substring(1);
        }
        if (string.length() == 1) {
            int n2 = "BCDFIJSZ".indexOf(string.charAt(0));
            if (n2 != -1) {
                string = PRIMITIVES[n2];
            }
        } else if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';') {
            string = string.substring(1, string.length() - 1);
        }
        while (n > 0) {
            string = String.valueOf(string) + "[]";
            --n;
        }
        return string;
    }

    public void disasm(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.disasm(fileInputStream);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var4_3 = null;
        try {
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {}
    }

    public void disasm(InputStream inputStream) throws IOException {
        this.disasmClassFile(new DataInputStream(inputStream));
        this.println();
        this.ipw.flush();
    }

    private void disasmAttributeInfo(DataInputStream dataInputStream) throws IOException {
        this.readAttributeInfo(dataInputStream).print();
    }

    private void disasmBytecode(InputStream inputStream, LocalVariableTableAttribute localVariableTableAttribute, LineNumberTableAttribute lineNumberTableAttribute, Map map) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(countingInputStream);
        while (true) {
            short s;
            short s2 = (short)countingInputStream.getCount();
            int n = dataInputStream.read();
            if (n == -1) {
                return;
            }
            if (lineNumberTableAttribute != null && (s = lineNumberTableAttribute.findLineNumber(s2)) != -1) {
                String string = (String)map.get(new Integer(s));
                if (string == null) {
                    string = "(Source line not available)";
                }
                this.println("            Line " + s + ": " + string);
            }
            this.print(String.valueOf(s2) + ": ");
            Instruction instruction = opcodeToInstruction[n];
            if (instruction == null) {
                this.println("??? (invalid opcode \"" + n + "\")");
                continue;
            }
            this.disasmInstruction(instruction, dataInputStream, s2, localVariableTableAttribute);
            this.println();
        }
    }

    private void disasmClassFile(DataInputStream dataInputStream) throws IOException {
        this.indentln("ClassFile {");
        this.println("magic = 0x" + Integer.toHexString(dataInputStream.readInt()));
        this.println("minor_version = " + dataInputStream.readShort());
        this.println("major_version = " + dataInputStream.readShort());
        this.constantPool = new ConstantPoolInfo[dataInputStream.readShort()];
        int n = 1;
        while (n < this.constantPool.length) {
            ConstantPoolInfo constantPoolInfo = this.readConstantPoolInfo(dataInputStream);
            int n2 = n;
            n = (short)(n2 + 1);
            this.constantPool[n2] = constantPoolInfo;
            int n3 = constantPoolInfo.getSizeInConstantPool();
            while (n3 > 1) {
                int n4 = n;
                n = (short)(n4 + 1);
                this.constantPool[n4] = null;
                --n3;
            }
        }
        this.indentln("constant_pool[] = {");
        int n5 = 1;
        while (n5 < this.constantPool.length) {
            this.print(String.valueOf(n5) + ": ");
            ConstantPoolInfo constantPoolInfo = this.constantPool[n5];
            constantPoolInfo.print();
            this.println();
            n5 = (short)(n5 + constantPoolInfo.getSizeInConstantPool());
        }
        this.unindentln("}");
        this.println("access_flags = " + Disassembler.decodeAccess(dataInputStream.readShort()));
        short s = dataInputStream.readShort();
        this.indent("this_class = " + s + " (");
        this.printConstantPoolEntry(s);
        this.unindentln(")");
        short s2 = dataInputStream.readShort();
        this.indent("super_class = " + s2 + " (");
        this.printConstantPoolEntry(s2);
        this.unindentln(")");
        this.indentln("interfaces[] = {");
        short s3 = dataInputStream.readShort();
        short s4 = 0;
        while (s4 < s3) {
            this.printConstantPoolEntry(null, dataInputStream.readShort());
            this.println();
            s4 = (short)(s4 + 1);
        }
        this.unindentln("}");
        this.indentln("fields[] = {");
        short s5 = dataInputStream.readShort();
        short s6 = 0;
        while (s6 < s5) {
            this.disasmFieldInfo(dataInputStream);
            this.println();
            s6 = (short)(s6 + 1);
        }
        this.unindentln("}");
        int n6 = dataInputStream.readShort();
        MethodInfo[] methodInfoArray = new MethodInfo[n6];
        int n7 = 0;
        while (n7 < n6) {
            methodInfoArray[n7] = this.readMethodInfo(dataInputStream);
            ++n7;
        }
        short s7 = dataInputStream.readShort();
        AttributeInfo[] attributeInfoArray = new AttributeInfo[s7];
        short s8 = 0;
        while (s8 < s7) {
            attributeInfoArray[s8] = this.readAttributeInfo(dataInputStream);
            s8 = (short)(s8 + 1);
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n8 = 0;
        while (n8 < attributeInfoArray.length) {
            ConstantPoolInfo constantPoolInfo;
            if (attributeInfoArray[n8] instanceof SourceFileAttribute && (constantPoolInfo = this.getConstantPoolEntry(((SourceFileAttribute)attributeInfoArray[n8]).sourceFileIndex)) instanceof ConstantUtf8Info) {
                Object var22_26;
                LineNumberReader lineNumberReader;
                String string = ((ConstantUtf8Info)constantPoolInfo).getValue();
                try {
                    lineNumberReader = new LineNumberReader(new FileReader(new File(this.sourceDirectory, string)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    break;
                }
                try {
                    String string2;
                    while ((string2 = lineNumberReader.readLine()) != null) {
                        hashMap.put(new Integer(lineNumberReader.getLineNumber()), string2);
                    }
                    var22_26 = null;
                }
                catch (Throwable throwable) {
                    var22_26 = null;
                    lineNumberReader.close();
                    throw throwable;
                }
                lineNumberReader.close();
            }
            ++n8;
        }
        this.indentln("methods[] = {");
        n8 = 0;
        while (n8 < methodInfoArray.length) {
            methodInfoArray[n8].print(hashMap);
            this.println();
            n8 = (short)(n8 + 1);
        }
        this.unindentln("}");
        this.indentln("attributes[] = {");
        int n9 = 0;
        while (n9 < attributeInfoArray.length) {
            attributeInfoArray[n9].print();
            this.println();
            n9 = (short)(n9 + 1);
        }
        this.unindentln("}");
        this.unindent("}");
    }

    private void disasmFieldInfo(DataInputStream dataInputStream) throws IOException {
        this.indentln("field_info {");
        this.println("access_flags = " + Disassembler.decodeAccess(dataInputStream.readShort()));
        this.printConstantPoolEntry("name_index", dataInputStream.readShort());
        this.println();
        this.printConstantPoolEntry("descriptor_index", dataInputStream.readShort());
        this.println();
        this.indentln("attributes[] = {");
        short s = dataInputStream.readShort();
        short s2 = 0;
        while (s2 < s) {
            this.disasmAttributeInfo(dataInputStream);
            this.println();
            s2 = (short)(s2 + 1);
        }
        this.unindentln("}");
        this.unindent("}");
    }

    private void disasmInstruction(Instruction instruction, DataInputStream dataInputStream, int n, LocalVariableTableAttribute localVariableTableAttribute) throws IOException {
        this.print(instruction.getMnemonic());
        Operand[] operandArray = instruction.getOperands();
        if (operandArray != null) {
            int n2 = 0;
            while (n2 < operandArray.length) {
                Operand operand = operandArray[n2];
                this.print(" ");
                operand.disasm(dataInputStream, n, localVariableTableAttribute, this);
                ++n2;
            }
        }
    }

    private ConstantPoolInfo getConstantPoolEntry(short s) {
        if ((s & 0xFFFF) < this.constantPool.length) {
            return this.constantPool[s & 0xFFFF];
        }
        return null;
    }

    void indent(String string) {
        this.ipw.print(string);
        this.ipw.indent();
    }

    void indentln(String string) {
        this.ipw.println(string);
        this.ipw.indent();
    }

    public static void main(String[] stringArray) throws IOException {
        Disassembler disassembler = new Disassembler();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.charAt(0) != '-') break;
            if (string.equals("-o")) {
                disassembler.setOut(new FileOutputStream(stringArray[++n]));
            } else if (string.equals("-verbose")) {
                disassembler.setVerbose(true);
            } else if (string.equals("-src")) {
                disassembler.setSourceDirectory(new File(stringArray[++n]));
            } else if (string.equals("-help")) {
                System.out.println("Usage:  java jexpr.Jdisasm [ -o <output-file> ] [ -verbose ] [ -src <source-dir> ] <class-file> ...");
                System.exit(0);
            } else {
                System.err.println("Unrecognized command line option \"" + string + "\"; try \"-help\".");
            }
            ++n;
        }
        if (n == stringArray.length) {
            System.err.println("Class file name missing, try \"-help\".");
            System.exit(1);
        }
        while (n < stringArray.length) {
            disassembler.disasm(new File(stringArray[n]));
            ++n;
        }
    }

    void print(int n) {
        this.ipw.print(n);
    }

    void print(String string) {
        this.ipw.print(string);
    }

    private void printConstantPoolEntry(String string, short s) {
        if (this.verbose) {
            if (string != null) {
                this.print(String.valueOf(string) + " = ");
            }
            this.print(String.valueOf(s) + " (");
            this.printConstantPoolEntry(s);
            this.print(")");
        } else {
            if (string != null) {
                if (string.endsWith("_index")) {
                    string = string.substring(0, string.length() - 6);
                }
                this.print(String.valueOf(string) + " = ");
            }
            this.printConstantPoolEntry(s);
        }
    }

    private void printConstantPoolEntry(short s) {
        if (this.verbose) {
            this.print(String.valueOf(s) + " (");
        }
        if ((s & 0xFFFF) < this.constantPool.length) {
            ConstantPoolInfo constantPoolInfo = this.constantPool[s];
            if (constantPoolInfo == null) {
                this.print("NULL CONSTANT POOL ENTRY");
            } else {
                constantPoolInfo.print();
            }
        } else {
            this.print("CONSTANT POOL INDEX OUT OF RANGE");
        }
        if (this.verbose) {
            this.print(")");
        }
    }

    void println() {
        this.ipw.println();
    }

    void println(String string) {
        this.ipw.println(string);
    }

    private AttributeInfo readAttributeBody(final String string, DataInputStream dataInputStream) throws IOException {
        int n;
        if (string.equals("ConstantValue")) {
            final short s = dataInputStream.readShort();
            return new AttributeInfo(){

                public void print() {
                    this.indent("ConstantValue " + s + " (");
                    this.printConstantPoolEntry(s);
                    this.unindent(")");
                }
            };
        }
        if (string.equals("Code")) {
            final short s = dataInputStream.readShort();
            final short s2 = dataInputStream.readShort();
            final byte[] byArray = Disassembler.readByteArray(dataInputStream, dataInputStream.readInt());
            final ExceptionTableEntry[] exceptionTableEntryArray = this.readExceptionTable(dataInputStream);
            final AttributeInfo[] attributeInfoArray = this.readAttributes(dataInputStream);
            return new SourceRelatedAttributeInfo(){

                public void print(Map map) {
                    this.indentln("Code {");
                    this.println("max_stack = " + s);
                    this.println("max_locals = " + s2);
                    this.indentln("code = { ");
                    LocalVariableTableAttribute localVariableTableAttribute = null;
                    LineNumberTableAttribute lineNumberTableAttribute = null;
                    int n = 0;
                    while (n < attributeInfoArray.length) {
                        AttributeInfo attributeInfo = attributeInfoArray[n];
                        if (attributeInfo instanceof LocalVariableTableAttribute) {
                            if (localVariableTableAttribute != null) {
                                throw new RuntimeException("Duplicate LocalVariableTable attribute");
                            }
                            localVariableTableAttribute = (LocalVariableTableAttribute)attributeInfo;
                        }
                        if (attributeInfo instanceof LineNumberTableAttribute) {
                            if (lineNumberTableAttribute != null) {
                                throw new RuntimeException("Duplicate LineNumberTable attribute");
                            }
                            lineNumberTableAttribute = (LineNumberTableAttribute)attributeInfo;
                        }
                        ++n;
                    }
                    try {
                        this.disasmBytecode(new ByteArrayInputStream(byArray), localVariableTableAttribute, lineNumberTableAttribute, map);
                    }
                    catch (IOException iOException) {}
                    this.unindentln("}");
                    this.indentln("exception_table = {");
                    int n2 = 0;
                    while (n2 < exceptionTableEntryArray.length) {
                        exceptionTableEntryArray[n2].print();
                        this.println();
                        ++n2;
                    }
                    this.unindentln("}");
                    this.indentln("attributes[] = {");
                    int n3 = 0;
                    while (n3 < attributeInfoArray.length) {
                        attributeInfoArray[n3].print();
                        this.println();
                        ++n3;
                    }
                    this.unindentln("}");
                    this.unindent("}");
                }
            };
        }
        if (string.equals("Exceptions")) {
            final short[] sArray = Disassembler.readShortArray(dataInputStream, dataInputStream.readShort());
            return new AttributeInfo(){

                public void print() {
                    this.indentln("Exceptions {");
                    this.indentln("exception_index_table = {");
                    int n = 0;
                    while (n < sArray.length) {
                        short s = sArray[n];
                        this.print(String.valueOf(s) + " (");
                        this.printConstantPoolEntry(s);
                        this.println("),");
                        n = (short)(n + 1);
                    }
                    this.unindentln("}");
                    this.unindent("}");
                }
            };
        }
        if (string.equals("InnerClasses")) {
            final short[] sArray = Disassembler.readShortArray(dataInputStream, 4 * dataInputStream.readShort());
            return new AttributeInfo(){

                public void print() {
                    this.indentln("InnerClasses {");
                    this.indentln("classes = {");
                    int n = 0;
                    while (n < sArray.length) {
                        this.indentln("{");
                        this.printConstantPoolEntry("inner_class_info_index", sArray[n]);
                        this.println();
                        short s = sArray[n + 1];
                        if (s == 0) {
                            this.print("(not a member)");
                        } else {
                            this.printConstantPoolEntry("outer_class_info_index", s);
                        }
                        this.println();
                        short s2 = sArray[n + 2];
                        if (s2 == 0) {
                            this.print("(anonymous)");
                        } else {
                            this.printConstantPoolEntry("inner_name_index", s2);
                        }
                        this.println();
                        this.println("inner_class_access_flags = " + Disassembler.decodeAccess(sArray[n + 3]));
                        this.unindentln(n == sArray.length - 1 ? "}" : "},");
                        n += 4;
                    }
                    this.unindentln("}");
                    this.unindent("}");
                }
            };
        }
        if (string.equals("Synthetic")) {
            return new AttributeInfo(){

                public void print() {
                    Disassembler.this.print("Synthetic");
                }
            };
        }
        if (string.equals("SourceFile")) {
            return new SourceFileAttribute(dataInputStream.readShort());
        }
        if (string.equals("LineNumberTable")) {
            return new LineNumberTableAttribute(Disassembler.readShortArray(dataInputStream, 2 * dataInputStream.readShort()));
        }
        if (string.equals("LocalVariableTable")) {
            return new LocalVariableTableAttribute(Disassembler.readShortArray(dataInputStream, 5 * dataInputStream.readShort()));
        }
        if (string.equals("Deprecated")) {
            return new AttributeInfo(){

                public void print() {
                    Disassembler.this.print("Deprecated");
                }
            };
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = dataInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return new AttributeInfo(byteArrayOutputStream){
            private byte[] info;
            {
                this.info = byteArrayOutputStream.toByteArray();
            }

            public void print() {
                this.indentln(String.valueOf(string) + " {");
                this.print("info = { ");
                int n = 0;
                while (n < this.info.length) {
                    this.print("0x" + Integer.toHexString(0xFF & this.info[n]) + ", ");
                    ++n;
                }
                this.println("}");
                this.unindent("}");
            }
        };
    }

    private AttributeInfo readAttributeInfo(DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        ConstantPoolInfo constantPoolInfo = this.getConstantPoolEntry(s);
        String string = constantPoolInfo == null ? "INVALID CONSTANT POOL INDEX" : (!(constantPoolInfo instanceof ConstantUtf8Info) ? "ATTRIBUTE NAME IS NOT UTF8" : ((ConstantUtf8Info)constantPoolInfo).getValue());
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        if (dataInputStream.read(byArray) != byArray.length) {
            throw new EOFException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
        AttributeInfo attributeInfo = this.readAttributeBody(string, dataInputStream2);
        int n2 = byteArrayInputStream.available();
        if (n2 > 0) {
            throw new RuntimeException(String.valueOf(n2) + " extraneous bytes in attribute \"" + string + "\"");
        }
        return attributeInfo;
    }

    private AttributeInfo[] readAttributes(DataInputStream dataInputStream) throws IOException {
        AttributeInfo[] attributeInfoArray = new AttributeInfo[dataInputStream.readShort()];
        int n = 0;
        while (n < attributeInfoArray.length) {
            attributeInfoArray[n] = this.readAttributeInfo(dataInputStream);
            ++n;
        }
        return attributeInfoArray;
    }

    private static byte[] readByteArray(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        if (inputStream.read(byArray) != n) {
            throw new EOFException("EOF in byte array");
        }
        return byArray;
    }

    private ConstantPoolInfo readConstantPoolInfo(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 7: {
                final short s = dataInputStream.readShort();
                return new ConstantPoolInfo(){

                    public void print() {
                        this.print("CONSTANT_Class_info { ");
                        this.printConstantPoolEntry("name_index", s);
                        this.print(" }");
                    }
                };
            }
            case 9: {
                final short s = dataInputStream.readShort();
                final short s2 = dataInputStream.readShort();
                return new ConstantPoolInfo(){

                    public void print() {
                        this.indentln("CONSTANT_Fieldref_info {");
                        this.printConstantPoolEntry("class_index", s);
                        this.println();
                        this.printConstantPoolEntry("name_and_type_index", s2);
                        this.println();
                        this.unindent("}");
                    }
                };
            }
            case 10: {
                final short s = dataInputStream.readShort();
                final short s3 = dataInputStream.readShort();
                return new ConstantPoolInfo(){

                    public void print() {
                        this.indentln("CONSTANT_Methodref_info {");
                        this.printConstantPoolEntry("class_index", s);
                        this.println();
                        this.printConstantPoolEntry("name_and_type_index", s3);
                        this.println();
                        this.unindent("}");
                    }
                };
            }
            case 11: {
                final short s = dataInputStream.readShort();
                final short s4 = dataInputStream.readShort();
                return new ConstantPoolInfo(){

                    public void print() {
                        this.indentln("CONSTANT_InterfaceMethodref_info {");
                        this.printConstantPoolEntry("class_index", s);
                        this.println();
                        this.printConstantPoolEntry("name_and_type_index", s4);
                        this.println();
                        this.unindent("}");
                    }
                };
            }
            case 8: {
                final short s = dataInputStream.readShort();
                return new ConstantPoolInfo(){

                    public void print() {
                        String string;
                        ConstantPoolInfo constantPoolInfo = this.getConstantPoolEntry(s);
                        string = constantPoolInfo == null ? "INVALID CONSTANT POOL INDEX" : (!(constantPoolInfo instanceof ConstantUtf8Info) ? "STRING CONSTANT VALUE IS NOT UTF8" : ((string = ((ConstantUtf8Info)constantPoolInfo).getValue()).length() > 80 ? String.valueOf(Disassembler.stringToJavaLiteral(string.substring(0, 80))) + "... (" + string.length() + " chars)" : Disassembler.stringToJavaLiteral(string)));
                        if (verbose) {
                            this.print("CONSTANT_String_info { string_index = " + s + " (" + string + ") }");
                        } else {
                            this.print(string);
                        }
                    }
                };
            }
            case 3: {
                final int n = dataInputStream.readInt();
                return new ConstantPoolInfo(){

                    public void print() {
                        this.print("CONSTANT_Integer_info { bytes = " + n + " }");
                    }
                };
            }
            case 4: {
                final float f = dataInputStream.readFloat();
                return new ConstantPoolInfo(){

                    public void print() {
                        this.print("CONSTANT_Float_info { bytes = " + f + " }");
                    }
                };
            }
            case 5: {
                final long l = dataInputStream.readLong();
                return new ConstantPoolInfo(){

                    public int getSizeInConstantPool() {
                        return 2;
                    }

                    public void print() {
                        this.print("CONSTANT_Long_info { high_bytes/low_bytes = " + l + " }");
                    }
                };
            }
            case 6: {
                final double d = dataInputStream.readDouble();
                return new ConstantPoolInfo(){

                    public int getSizeInConstantPool() {
                        return 2;
                    }

                    public void print() {
                        this.print("CONSTANT_Double_info { high_bytes/low_bytes = " + d + " }");
                    }
                };
            }
            case 12: {
                final short s = dataInputStream.readShort();
                final short s5 = dataInputStream.readShort();
                return new ConstantPoolInfo(){

                    public void print() {
                        this.indentln("CONSTANT_NameAndType_info {");
                        this.printConstantPoolEntry("name_index", s);
                        this.println();
                        this.printConstantPoolEntry("descriptor_index", s5);
                        this.println();
                        this.unindent("}");
                    }
                };
            }
            case 1: {
                return new ConstantUtf8Info(dataInputStream.readUTF());
            }
        }
        throw new RuntimeException("Invalid cp_info tag \"" + by + "\"");
    }

    private ExceptionTableEntry[] readExceptionTable(DataInputStream dataInputStream) throws IOException {
        ExceptionTableEntry[] exceptionTableEntryArray = new ExceptionTableEntry[dataInputStream.readShort()];
        int n = 0;
        while (n < exceptionTableEntryArray.length) {
            exceptionTableEntryArray[n] = new ExceptionTableEntry(dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort());
            n = (short)(n + 1);
        }
        return exceptionTableEntryArray;
    }

    private MethodInfo readMethodInfo(DataInputStream dataInputStream) throws IOException {
        final short s = dataInputStream.readShort();
        final short s2 = dataInputStream.readShort();
        final short s3 = dataInputStream.readShort();
        short s4 = dataInputStream.readShort();
        final AttributeInfo[] attributeInfoArray = new AttributeInfo[s4];
        short s5 = 0;
        while (s5 < s4) {
            attributeInfoArray[s5] = this.readAttributeInfo(dataInputStream);
            s5 = (short)(s5 + 1);
        }
        return new MethodInfo(){

            public void print(Map map) {
                this.indentln("method_info {");
                this.println("access_flags = " + Disassembler.decodeAccess(s));
                this.printConstantPoolEntry("name_index", s2);
                this.println();
                this.printConstantPoolEntry("descriptor_index", s3);
                this.println();
                this.indentln("attributes[] = {");
                int n = 0;
                while (n < attributeInfoArray.length) {
                    AttributeInfo attributeInfo = attributeInfoArray[n];
                    if (attributeInfo instanceof SourceRelatedAttributeInfo) {
                        ((SourceRelatedAttributeInfo)attributeInfo).print(map);
                    } else {
                        attributeInfo.print();
                    }
                    this.println();
                    n = (short)(n + 1);
                }
                this.unindentln("}");
                this.unindent("}");
            }
        };
    }

    private static short[] readShortArray(DataInputStream dataInputStream, int n) throws IOException {
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = dataInputStream.readShort();
            ++n2;
        }
        return sArray;
    }

    public void setOut(OutputStream outputStream) {
        this.ipw = new IndentPrintWriter(outputStream);
    }

    public void setSourceDirectory(File file) {
        this.sourceDirectory = file;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    private static String stringToJavaLiteral(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = "\r\n\"\t\b".indexOf(c);
            if (n2 == -1) {
                ++n;
            } else {
                string = String.valueOf(string.substring(0, n)) + '\\' + "rn\"tb".charAt(n2) + string.substring(n + 1);
                n += 2;
            }
            if (n >= 80) break;
        }
        return String.valueOf('\"') + string + '\"';
    }

    void unindent(String string) {
        this.ipw.unindent();
        this.ipw.print(string);
    }

    void unindentln(String string) {
        this.ipw.unindent();
        this.ipw.println(string);
    }

    private static interface MethodInfo {
        public void print(Map var1);
    }

    private static interface AttributeInfo {
        public void print();
    }

    private static abstract class SourceRelatedAttributeInfo
    implements AttributeInfo {
        SourceRelatedAttributeInfo() {
        }

        public void print() {
            throw new UnsupportedOperationException("print");
        }

        public abstract void print(Map var1);
    }

    private class SourceFileAttribute
    implements AttributeInfo {
        final short sourceFileIndex;

        SourceFileAttribute(short s) {
            this.sourceFileIndex = s;
        }

        public void print() {
            Disassembler.this.indentln("SourceFile {");
            Disassembler.this.printConstantPoolEntry("sourcefile_index", this.sourceFileIndex);
            Disassembler.this.println();
            Disassembler.this.unindent("}");
        }
    }

    public class LineNumberTableAttribute
    implements AttributeInfo {
        private final short[] data;

        public LineNumberTableAttribute(short[] sArray) {
            this.data = sArray;
        }

        public short findLineNumber(short s) {
            int n = 0;
            while (n < this.data.length) {
                if (this.data[n] == s) {
                    return this.data[n + 1];
                }
                n = (short)(n + 2);
            }
            return -1;
        }

        public void print() {
            Disassembler.this.indentln("LineNumberTable {");
            Disassembler.this.indentln("line_number_table = {");
            int n = 0;
            while (n < this.data.length) {
                Disassembler.this.print("start_pc = " + this.data[n]);
                Disassembler.this.print(", ");
                Disassembler.this.println("line_number = " + this.data[n + 1]);
                n = (short)(n + 2);
            }
            Disassembler.this.unindentln("}");
            Disassembler.this.unindent("}");
        }
    }

    private class LocalVariableTableAttribute
    implements AttributeInfo {
        private short[] data;

        public LocalVariableTableAttribute(short[] sArray) {
            this.data = sArray;
        }

        public String find(short s, int n) {
            int n2 = 0;
            while (n2 < this.data.length) {
                short s2 = this.data[n2];
                short s3 = this.data[n2 + 1];
                if (n >= s2 && n <= s2 + s3 && s == this.data[n2 + 4]) {
                    String string = ((ConstantUtf8Info)Disassembler.this.getConstantPoolEntry(this.data[n2 + 2])).getValue();
                    String string2 = ((ConstantUtf8Info)Disassembler.this.getConstantPoolEntry(this.data[n2 + 3])).getValue();
                    return String.valueOf(Disassembler.decodeDescriptor(string2)) + " " + string;
                }
                n2 += 5;
            }
            return "anonymous";
        }

        public void print() {
            Disassembler.this.indentln("LocalVariableTable {");
            Disassembler.this.indentln("local_variable_table = {");
            int n = 0;
            while (n < this.data.length) {
                Disassembler.this.print("start_pc = " + this.data[n]);
                Disassembler.this.print(", ");
                Disassembler.this.print("length = " + this.data[n + 1]);
                Disassembler.this.print(", ");
                Disassembler.this.printConstantPoolEntry("name_index", this.data[n + 2]);
                Disassembler.this.print(", ");
                Disassembler.this.printConstantPoolEntry("descriptor_index", this.data[n + 3]);
                Disassembler.this.print(", ");
                Disassembler.this.println("index = " + this.data[n + 4]);
                n += 5;
            }
            Disassembler.this.unindentln("}");
            Disassembler.this.unindent("}");
        }
    }

    private class ExceptionTableEntry {
        private short startPC;
        private short endPC;
        private short handlerPC;
        private short catchType;

        ExceptionTableEntry(short s, short s2, short s3, short s4) {
            this.startPC = s;
            this.endPC = s2;
            this.handlerPC = s3;
            this.catchType = s4;
        }

        public void print() {
            Disassembler.this.print("start_pc = " + this.startPC + ", end_pc = " + this.endPC + ", handler_pc = " + this.handlerPC + ", catch_type = " + this.catchType + " (");
            if (this.catchType == 0) {
                Disassembler.this.print("finally");
            } else {
                Disassembler.this.printConstantPoolEntry(this.catchType);
            }
            Disassembler.this.print(")");
        }
    }

    private static class Instruction {
        private final String mnemonic;
        private final Operand[] operands;

        public Instruction(String string, Operand[] operandArray) {
            this.mnemonic = string;
            this.operands = operandArray;
        }

        public String getMnemonic() {
            return this.mnemonic;
        }

        public Operand[] getOperands() {
            return this.operands;
        }
    }

    private static interface Operand {
        public void disasm(DataInputStream var1, int var2, LocalVariableTableAttribute var3, Disassembler var4) throws IOException;
    }

    private static class IndentPrintWriter
    extends PrintWriter {
        private static final char[] INDENTATION_CHARS = new char[]{' ', ' '};
        private boolean atBOL = true;
        private int indentation = 0;

        public IndentPrintWriter(OutputStream outputStream) {
            super(outputStream);
        }

        private void handleIndentation() {
            if (this.atBOL) {
                int n = 0;
                while (n < this.indentation) {
                    super.write(INDENTATION_CHARS, 0, INDENTATION_CHARS.length);
                    ++n;
                }
                this.atBOL = false;
            }
        }

        public void indent() {
            ++this.indentation;
        }

        public void println() {
            super.println();
            this.atBOL = true;
        }

        public void unindent() {
            --this.indentation;
        }

        public void write(String string, int n, int n2) {
            this.handleIndentation();
            super.write(string, n, n2);
        }

        public void write(char[] cArray, int n, int n2) {
            this.handleIndentation();
            super.write(cArray, n, n2);
        }
    }

    private static abstract class ConstantPoolInfo {
        ConstantPoolInfo() {
        }

        public int getSizeInConstantPool() {
            return 1;
        }

        public abstract void print();
    }

    private class ConstantUtf8Info
    extends ConstantPoolInfo {
        private String value;

        public ConstantUtf8Info(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }

        public void print() {
            Disassembler.this.print(this.value);
        }
    }

    private static class CountingInputStream
    extends InputStream {
        private InputStream is;
        private long count = 0L;

        public CountingInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public long getCount() {
            return this.count;
        }

        public int read() throws IOException {
            int n = this.is.read();
            if (n != -1) {
                ++this.count;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.count += (long)n3;
            }
            return n3;
        }
    }
}

