/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastAsQName;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class CastExpression
extends ComputedExpression {
    private Expression source;
    private AtomicType targetType;
    private boolean allowEmpty = false;

    public CastExpression(Expression expression, AtomicType atomicType) throws XPathException {
        this.source = expression;
        this.targetType = atomicType;
    }

    public CastExpression(Expression expression, AtomicType atomicType, boolean bl) throws XPathException {
        this.source = expression;
        this.allowEmpty = bl;
        this.targetType = atomicType;
    }

    public Expression simplify() throws XPathException {
        this.source = this.source.simplify();
        if (this.source instanceof AtomicValue) {
            if (Type.isSubType(this.targetType, Type.QNAME_TYPE)) {
                return this;
            }
            return (AtomicValue)this.evaluateItem(null);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.source = this.source.analyze(staticContext);
        SequenceType sequenceType = new SequenceType(Type.ATOMIC_TYPE, this.getCardinality());
        RoleLocator roleLocator = new RoleLocator(2, "cast as", 0);
        this.source = TypeChecker.staticTypeCheck(this.source, sequenceType, false, roleLocator);
        if (Type.isSubType(this.source.getItemType(), this.targetType)) {
            return this.source;
        }
        if (Type.isSubType(this.targetType, Type.QNAME_TYPE)) {
            return new CastAsQName(this.source).analyze(staticContext);
        }
        if (this.source instanceof AtomicValue) {
            return (AtomicValue)this.evaluateItem(null);
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.source = this.source.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.source};
        return expressionArray;
    }

    public int computeCardinality() {
        return this.allowEmpty ? 768 : 512;
    }

    public ItemType getItemType() {
        return this.targetType;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.source.evaluateItem(xPathContext);
        if (atomicValue == null) {
            if (this.allowEmpty) {
                throw new XPathException.Dynamic("Cast does not allow an empty sequence");
            }
            return null;
        }
        try {
            return atomicValue.convert(this.targetType);
        }
        catch (XPathException xPathException) {
            this.dynamicError(xPathException.getMessage());
            return null;
        }
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "cast as " + this.targetType.toString());
        this.source.display(n + 1, namePool);
    }
}

