
/*  A Bison parser, made from /home/gray/mailutils/mailbox/parsedate.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	T_AGO	257
#define	T_DST	258
#define	T_ID	259
#define	T_DAY	260
#define	T_DAY_UNIT	261
#define	T_DAYZONE	262
#define	T_HOUR_UNIT	263
#define	T_MINUTE_UNIT	264
#define	T_MONTH	265
#define	T_MONTH_UNIT	266
#define	T_SEC_UNIT	267
#define	T_SNUMBER	268
#define	T_UNUMBER	269
#define	T_YEAR_UNIT	270
#define	T_ZONE	271
#define	T_MERIDIAN	272

#line 1 "parsedate.y"

/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 2003 Free Software Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA  */
  
/* A heavily modified version of the well-known public domain getdate.y.
   It was originally written by Steven M. Bellovin <smb@research.att.com>
   while at the University of North Carolina at Chapel Hill.  Later tweaked
   by a couple of people on Usenet.  Completely overhauled by Rich $alz
   <rsalz@bbn.com> and Jim Berets <jberets@bbn.com> in August, 1990.
   Rewritten using a proper union by Sergey Poznyakoff <gray@gnu.org> */

#ifdef HAVE_CONFIG_H
# include <config.h>
# ifdef HAVE_ALLOCA_H
#  include <alloca.h>
# endif
#endif

#include <stdio.h>
#include <ctype.h>

#if HAVE_STDLIB_H
# include <stdlib.h> /* for `free'; used by Bison 1.27 */
#endif

#if defined (STDC_HEADERS) || (!defined (isascii) && !defined (HAVE_ISASCII))
# define IN_CTYPE_DOMAIN(c) 1
#else
# define IN_CTYPE_DOMAIN(c) isascii(c)
#endif

#define ISSPACE(c) (IN_CTYPE_DOMAIN (c) && isspace (c))
#define ISALPHA(c) (IN_CTYPE_DOMAIN (c) && isalpha (c))
#define ISUPPER(c) (IN_CTYPE_DOMAIN (c) && isupper (c))
#define ISDIGIT_LOCALE(c) (IN_CTYPE_DOMAIN (c) && isdigit (c))

/* ISDIGIT differs from ISDIGIT_LOCALE, as follows:
   - Its arg may be any int or unsigned int; it need not be an unsigned char.
   - It's guaranteed to evaluate its argument exactly once.
   - It's typically faster.
   Posix 1003.2-1992 section 2.5.2.1 page 50 lines 1556-1558 says that
   only '0' through '9' are digits.  Prefer ISDIGIT to ISDIGIT_LOCALE unless
   it's important to use the locale's definition of `digit' even when the
   host does not conform to Posix.  */
#define ISDIGIT(c) ((unsigned) (c) - '0' <= 9)

#if defined (STDC_HEADERS) || defined (USG)
# include <string.h>
#endif

/* Some old versions of bison generate parsers that use bcopy.
   That loses on systems that don't provide the function, so we have
   to redefine it here.  */
#if !defined (HAVE_BCOPY) && defined (HAVE_MEMCPY) && !defined (bcopy)
# define bcopy(from, to, len) memcpy ((to), (from), (len))
#endif

static int pd_yylex ();
static int pd_yyerror ();

#define EPOCH		1970
#define HOUR(x)		((x) * 60)

#define MAX_BUFF_LEN    128   /* size of buffer to read the date into */

/*
**  An entry in the lexical lookup table.
*/
typedef struct _lex_tab {
  const char	*name;
  int		type;
  int		value;
} SYMBOL;


/*
**  Meridian:  am, pm, or 24-hour style.
*/
typedef enum meridian {
  MERam,
  MERpm,
  MER24
} MERIDIAN;

#define PD_MASK_SECOND   00001
#define PD_MASK_MINUTE   00002
#define PD_MASK_HOUR     00004
#define PD_MASK_DAY      00010
#define PD_MASK_MONTH    00020
#define PD_MASK_YEAR     00040
#define PD_MASK_TZ       00100 
#define PD_MASK_MERIDIAN 00200
#define PD_MASK_ORDINAL  00400
#define PD_MASK_NUMBER   01000

#define PD_MASK_TIME PD_MASK_SECOND|PD_MASK_MINUTE|PD_MASK_HOUR
#define PD_MASK_DATE PD_MASK_DAY|PD_MASK_MONTH|PD_MASK_YEAR
#define PD_MASK_DOW PD_MASK_NUMBER
 
#define MASK_IS_SET(f,m) (((f)&(m))==(m))
#define MASK_TEST(f,m)   ((f)&(m)) 
struct pd_date
{
  int mask;
  int day;
  int hour;
  int minute;
  int month;
  int second;
  int year;
  int tz;
  enum meridian meridian;
  int number;
  int ordinal;
};

#define DATE_INIT(date) date.mask = 0
#define DATE_SET(date, memb, m, val) \
 do { date . memb = val; date.mask |= m; } while (0)

#define SET_SECOND(d,v)   DATE_SET(d,second,PD_MASK_SECOND,v)
#define SET_MINUTE(d,v)   DATE_SET(d,minute,PD_MASK_MINUTE,v)  
#define SET_HOUR(d,v)     DATE_SET(d,hour,PD_MASK_HOUR,v)
#define SET_DAY(d,v)      DATE_SET(d,day,PD_MASK_DAY,v)   
#define SET_MONTH(d,v)    DATE_SET(d,month,PD_MASK_MONTH,v)
#define SET_YEAR(d,v)     DATE_SET(d,year,PD_MASK_YEAR,v)  
#define SET_TZ(d,v)       DATE_SET(d,tz,PD_MASK_TZ,v)
#define SET_MERIDIAN(d,v) DATE_SET(d,meridian,PD_MASK_MERIDIAN,v)
#define SET_ORDINAL(d,v)  DATE_SET(d,ordinal,PD_MASK_ORDINAL,v)
#define SET_NUMBER(d,v)   DATE_SET(d,number,PD_MASK_NUMBER,v) 

int
pd_date_union (struct pd_date *a, struct pd_date *b)
{
  int diff = (~a->mask) & b->mask;
  if (!diff)
    return 1;

  a->mask |= diff;
  
  if (diff & PD_MASK_SECOND)
    a->second = b->second;
  
  if (diff & PD_MASK_MINUTE)
    a->minute = b->minute;

  if (diff & PD_MASK_HOUR)
    a->hour = b->hour;

  if (diff & PD_MASK_DAY)
    a->day = b->day;

  if (diff & PD_MASK_MONTH)
    a->month = b->month;

  if (diff & PD_MASK_YEAR)
    a->year = b->year;

  if (diff & PD_MASK_TZ)
    a->tz = b->tz;

  if (diff & PD_MASK_MERIDIAN)
    a->meridian = b->meridian;

  if (diff & PD_MASK_ORDINAL)
    a->ordinal = b->ordinal;

  if (diff & PD_MASK_NUMBER)
    a->number = b->number;

  return 0;
}

struct pd_datespec
{
  struct pd_date date;
  struct pd_date rel;
};

static struct pd_datespec pd;
 
static const char	*pd_yyinput;


#line 200 "parsedate.y"
typedef union {
  int number;
  enum meridian meridian;
  struct pd_date date;
  struct pd_datespec datespec;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		69
#define	YYFLAG		-32768
#define	YYNTBASE	22

#define YYTRANSLATE(x) ((unsigned)(x) <= 272 ? pd_yytranslate[x] : 33)

static const char pd_yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    20,     2,     2,    21,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    19,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18
};

#if YYDEBUG != 0
static const short pd_yyprhs[] = {     0,
     0,     2,     3,     6,     9,    12,    14,    16,    18,    20,
    23,    28,    33,    40,    47,    49,    51,    54,    56,    59,
    62,    66,    72,    76,    80,    83,    88,    91,    95,   101,
   104,   106,   108,   111,   114,   117,   119,   122,   125,   127,
   130,   133,   135,   138,   141,   143,   146,   149,   151,   154,
   157,   159,   160
};

static const short pd_yyrhs[] = {    23,
     0,     0,    23,    24,     0,    23,    29,     0,    23,    15,
     0,    25,     0,    26,     0,    28,     0,    27,     0,    15,
    18,     0,    15,    19,    15,    32,     0,    15,    19,    15,
    14,     0,    15,    19,    15,    19,    15,    32,     0,    15,
    19,    15,    19,    15,    14,     0,    17,     0,     8,     0,
    17,     4,     0,     6,     0,     6,    20,     0,    15,     6,
     0,    15,    21,    15,     0,    15,    21,    15,    21,    15,
     0,    15,    14,    14,     0,    15,    11,    14,     0,    11,
    15,     0,    11,    15,    20,    15,     0,    15,    11,     0,
    15,    11,    15,     0,     6,    11,    15,    25,    15,     0,
    30,     3,     0,    30,     0,    31,     0,    30,    31,     0,
    15,    16,     0,    14,    16,     0,    16,     0,    15,    12,
     0,    14,    12,     0,    12,     0,    15,     7,     0,    14,
     7,     0,     7,     0,    15,     9,     0,    14,     9,     0,
     9,     0,    15,    10,     0,    14,    10,     0,    10,     0,
    15,    13,     0,    14,    13,     0,    13,     0,     0,    18,
     0
};

#endif

#if YYDEBUG != 0
static const short pd_yyrline[] = { 0,
   221,   227,   232,   238,   244,   275,   276,   277,   278,   281,
   287,   294,   304,   312,   325,   330,   335,   342,   348,   354,
   362,   368,   388,   396,   413,   419,   426,   432,   439,   454,
   464,   468,   474,   482,   487,   492,   497,   502,   507,   512,
   517,   522,   527,   532,   537,   542,   547,   552,   557,   562,
   567,   574,   578
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const pd_yytname[] = {   "$","error","$undefined.","T_AGO",
"T_DST","T_ID","T_DAY","T_DAY_UNIT","T_DAYZONE","T_HOUR_UNIT","T_MINUTE_UNIT",
"T_MONTH","T_MONTH_UNIT","T_SEC_UNIT","T_SNUMBER","T_UNUMBER","T_YEAR_UNIT",
"T_ZONE","T_MERIDIAN","':'","','","'/'","input","spec","item","time","zone",
"day","date","rel","relspec","relunit","o_merid", NULL
};
#endif

static const short pd_yyr1[] = {     0,
    22,    23,    23,    23,    23,    24,    24,    24,    24,    25,
    25,    25,    25,    25,    26,    26,    26,    27,    27,    27,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    29,
    29,    30,    30,    31,    31,    31,    31,    31,    31,    31,
    31,    31,    31,    31,    31,    31,    31,    31,    31,    31,
    31,    32,    32
};

static const short pd_yyr2[] = {     0,
     1,     0,     2,     2,     2,     1,     1,     1,     1,     2,
     4,     4,     6,     6,     1,     1,     2,     1,     2,     2,
     3,     5,     3,     3,     2,     4,     2,     3,     5,     2,
     1,     1,     2,     2,     2,     1,     2,     2,     1,     2,
     2,     1,     2,     2,     1,     2,     2,     1,     2,     2,
     1,     0,     1
};

static const short pd_yydefact[] = {     2,
     1,    18,    42,    16,    45,    48,     0,    39,    51,     0,
     5,    36,    15,     3,     6,     7,     9,     8,     4,    31,
    32,     0,    19,    25,    41,    44,    47,    38,    50,    35,
    20,    40,    43,    46,    27,    37,    49,     0,    34,    10,
     0,     0,    17,    30,     0,    33,     0,     0,    24,    28,
    23,    52,    21,     0,     0,    26,    12,    53,     0,    11,
     0,    29,    52,    22,    14,    13,     0,     0,     0
};

static const short pd_yydefgoto[] = {    67,
     1,    14,    15,    16,    17,    18,    19,    20,    21,    60
};

static const short pd_yypact[] = {-32768,
    22,    -9,-32768,-32768,-32768,-32768,     4,-32768,-32768,    33,
    -6,-32768,     5,-32768,-32768,-32768,-32768,-32768,-32768,    11,
-32768,     7,-32768,    21,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,     2,-32768,-32768,    30,-32768,-32768,
    32,    37,-32768,-32768,    41,-32768,    40,    50,-32768,-32768,
-32768,    42,    38,    45,    51,-32768,-32768,-32768,    52,-32768,
    53,-32768,    44,-32768,-32768,-32768,    69,    70,-32768
};

static const short pd_yypgoto[] = {-32768,
-32768,-32768,    24,-32768,-32768,-32768,-32768,-32768,    54,     9
};


#define	YYLAST		74


static const short pd_yytable[] = {    31,
    32,    22,    33,    34,    35,    36,    37,    38,    43,    39,
    23,    40,    41,    44,    42,    49,    50,     3,    24,     5,
     6,    47,     8,     9,    10,    45,    12,     2,     3,     4,
     5,     6,     7,     8,     9,    10,    11,    12,    13,    25,
    48,    26,    27,    51,    28,    29,    52,    32,    30,    33,
    34,    53,    36,    37,    54,    57,    39,    65,    61,    58,
    59,    58,    40,    41,    56,    62,    63,    64,    68,    69,
    55,    66,     0,    46
};

static const short pd_yycheck[] = {     6,
     7,    11,     9,    10,    11,    12,    13,    14,     4,    16,
    20,    18,    19,     3,    21,    14,    15,     7,    15,     9,
    10,    15,    12,    13,    14,    15,    16,     6,     7,     8,
     9,    10,    11,    12,    13,    14,    15,    16,    17,     7,
    20,     9,    10,    14,    12,    13,    15,     7,    16,     9,
    10,    15,    12,    13,    15,    14,    16,    14,    21,    18,
    19,    18,    18,    19,    15,    15,    15,    15,     0,     0,
    47,    63,    -1,    20
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define pd_yyerrok		(pd_yyerrstatus = 0)
#define pd_yyclearin	(pd_yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto pd_yyacceptlab
#define YYABORT 	goto pd_yyabortlab
#define YYERROR		goto pd_yyerrlab1
/* Like YYERROR except do call pd_yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto pd_yyerrlab
#define YYRECOVERING()  (!!pd_yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (pd_yychar == YYEMPTY && pd_yylen == 1)				\
    { pd_yychar = (token), pd_yylval = (value);			\
      pd_yychar1 = YYTRANSLATE (pd_yychar);				\
      YYPOPSTACK;						\
      goto pd_yybackup;						\
    }								\
  else								\
    { pd_yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		pd_yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		pd_yylex(&pd_yylval, &pd_yylloc, YYLEX_PARAM)
#else
#define YYLEX		pd_yylex(&pd_yylval, &pd_yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		pd_yylex(&pd_yylval, YYLEX_PARAM)
#else
#define YYLEX		pd_yylex(&pd_yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	pd_yychar;			/*  the lookahead symbol		*/
YYSTYPE	pd_yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE pd_yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int pd_yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int pd_yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __pd_yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __pd_yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__pd_yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__pd_yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into pd_yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int pd_yyparse (void *);
#else
int pd_yyparse (void);
#endif
#endif

int
pd_yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int pd_yystate;
  register int pd_yyn;
  register short *pd_yyssp;
  register YYSTYPE *pd_yyvsp;
  int pd_yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int pd_yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	pd_yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE pd_yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *pd_yyss = pd_yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *pd_yyvs = pd_yyvsa;	/*  to allow pd_yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE pd_yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *pd_yyls = pd_yylsa;
  YYLTYPE *pd_yylsp;

#define YYPOPSTACK   (pd_yyvsp--, pd_yyssp--, pd_yylsp--)
#else
#define YYPOPSTACK   (pd_yyvsp--, pd_yyssp--)
#endif

  int pd_yystacksize = YYINITDEPTH;
  int pd_yyfree_stacks = 0;

#ifdef YYPURE
  int pd_yychar;
  YYSTYPE pd_yylval;
  int pd_yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE pd_yylloc;
#endif
#endif

  YYSTYPE pd_yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int pd_yylen;

#if YYDEBUG != 0
  if (pd_yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  pd_yystate = 0;
  pd_yyerrstatus = 0;
  pd_yynerrs = 0;
  pd_yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  pd_yyssp = pd_yyss - 1;
  pd_yyvsp = pd_yyvs;
#ifdef YYLSP_NEEDED
  pd_yylsp = pd_yyls;
#endif

/* Push a new state, which is found in  pd_yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
pd_yynewstate:

  *++pd_yyssp = pd_yystate;

  if (pd_yyssp >= pd_yyss + pd_yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *pd_yyvs1 = pd_yyvs;
      short *pd_yyss1 = pd_yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *pd_yyls1 = pd_yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = pd_yyssp - pd_yyss + 1;

#ifdef pd_yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if pd_yyoverflow is a macro.  */
      pd_yyoverflow("parser stack overflow",
		 &pd_yyss1, size * sizeof (*pd_yyssp),
		 &pd_yyvs1, size * sizeof (*pd_yyvsp),
		 &pd_yyls1, size * sizeof (*pd_yylsp),
		 &pd_yystacksize);
#else
      pd_yyoverflow("parser stack overflow",
		 &pd_yyss1, size * sizeof (*pd_yyssp),
		 &pd_yyvs1, size * sizeof (*pd_yyvsp),
		 &pd_yystacksize);
#endif

      pd_yyss = pd_yyss1; pd_yyvs = pd_yyvs1;
#ifdef YYLSP_NEEDED
      pd_yyls = pd_yyls1;
#endif
#else /* no pd_yyoverflow */
      /* Extend the stack our own way.  */
      if (pd_yystacksize >= YYMAXDEPTH)
	{
	  pd_yyerror("parser stack overflow");
	  if (pd_yyfree_stacks)
	    {
	      free (pd_yyss);
	      free (pd_yyvs);
#ifdef YYLSP_NEEDED
	      free (pd_yyls);
#endif
	    }
	  return 2;
	}
      pd_yystacksize *= 2;
      if (pd_yystacksize > YYMAXDEPTH)
	pd_yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      pd_yyfree_stacks = 1;
#endif
      pd_yyss = (short *) YYSTACK_ALLOC (pd_yystacksize * sizeof (*pd_yyssp));
      __pd_yy_memcpy ((char *)pd_yyss, (char *)pd_yyss1,
		   size * (unsigned int) sizeof (*pd_yyssp));
      pd_yyvs = (YYSTYPE *) YYSTACK_ALLOC (pd_yystacksize * sizeof (*pd_yyvsp));
      __pd_yy_memcpy ((char *)pd_yyvs, (char *)pd_yyvs1,
		   size * (unsigned int) sizeof (*pd_yyvsp));
#ifdef YYLSP_NEEDED
      pd_yyls = (YYLTYPE *) YYSTACK_ALLOC (pd_yystacksize * sizeof (*pd_yylsp));
      __pd_yy_memcpy ((char *)pd_yyls, (char *)pd_yyls1,
		   size * (unsigned int) sizeof (*pd_yylsp));
#endif
#endif /* no pd_yyoverflow */

      pd_yyssp = pd_yyss + size - 1;
      pd_yyvsp = pd_yyvs + size - 1;
#ifdef YYLSP_NEEDED
      pd_yylsp = pd_yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (pd_yydebug)
	fprintf(stderr, "Stack size increased to %d\n", pd_yystacksize);
#endif

      if (pd_yyssp >= pd_yyss + pd_yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (pd_yydebug)
    fprintf(stderr, "Entering state %d\n", pd_yystate);
#endif

  goto pd_yybackup;
 pd_yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* pd_yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  pd_yyn = pd_yypact[pd_yystate];
  if (pd_yyn == YYFLAG)
    goto pd_yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* pd_yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (pd_yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (pd_yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      pd_yychar = YYLEX;
    }

  /* Convert token to internal form (in pd_yychar1) for indexing tables with */

  if (pd_yychar <= 0)		/* This means end of input. */
    {
      pd_yychar1 = 0;
      pd_yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (pd_yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      pd_yychar1 = YYTRANSLATE(pd_yychar);

#if YYDEBUG != 0
      if (pd_yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", pd_yychar, pd_yytname[pd_yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, pd_yychar, pd_yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  pd_yyn += pd_yychar1;
  if (pd_yyn < 0 || pd_yyn > YYLAST || pd_yycheck[pd_yyn] != pd_yychar1)
    goto pd_yydefault;

  pd_yyn = pd_yytable[pd_yyn];

  /* pd_yyn is what to do for this token type in this state.
     Negative => reduce, -pd_yyn is rule number.
     Positive => shift, pd_yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (pd_yyn < 0)
    {
      if (pd_yyn == YYFLAG)
	goto pd_yyerrlab;
      pd_yyn = -pd_yyn;
      goto pd_yyreduce;
    }
  else if (pd_yyn == 0)
    goto pd_yyerrlab;

  if (pd_yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (pd_yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", pd_yychar, pd_yytname[pd_yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (pd_yychar != YYEOF)
    pd_yychar = YYEMPTY;

  *++pd_yyvsp = pd_yylval;
#ifdef YYLSP_NEEDED
  *++pd_yylsp = pd_yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (pd_yyerrstatus) pd_yyerrstatus--;

  pd_yystate = pd_yyn;
  goto pd_yynewstate;

/* Do the default action for the current state.  */
pd_yydefault:

  pd_yyn = pd_yydefact[pd_yystate];
  if (pd_yyn == 0)
    goto pd_yyerrlab;

/* Do a reduction.  pd_yyn is the number of a rule to reduce with.  */
pd_yyreduce:
  pd_yylen = pd_yyr2[pd_yyn];
  if (pd_yylen > 0)
    pd_yyval = pd_yyvsp[1-pd_yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (pd_yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       pd_yyn, pd_yyrline[pd_yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = pd_yyprhs[pd_yyn]; pd_yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", pd_yytname[pd_yyrhs[i]]);
      fprintf (stderr, " -> %s\n", pd_yytname[pd_yyr1[pd_yyn]]);
    }
#endif


  switch (pd_yyn) {

case 1:
#line 222 "parsedate.y"
{
	    pd = pd_yyvsp[0].datespec;
	  ;
    break;}
case 2:
#line 228 "parsedate.y"
{
	    DATE_INIT (pd_yyval.datespec.date);
	    DATE_INIT (pd_yyval.datespec.rel);
	  ;
    break;}
case 3:
#line 233 "parsedate.y"
{
	    if (pd_date_union (&pd_yyvsp[-1].datespec.date, &pd_yyvsp[0].date))
	      YYERROR;
	    pd_yyval.datespec = pd_yyvsp[-1].datespec;
	  ;
    break;}
case 4:
#line 239 "parsedate.y"
{
	    if (pd_date_union (&pd_yyvsp[-1].datespec.rel, &pd_yyvsp[0].date))
	      YYERROR;
	    pd_yyval.datespec = pd_yyvsp[-1].datespec;
	  ;
    break;}
case 5:
#line 245 "parsedate.y"
{
	    if (MASK_IS_SET (pd_yyvsp[-1].datespec.date.mask, (PD_MASK_TIME|PD_MASK_DATE))
		&& !pd_yyvsp[-1].datespec.rel.mask)
	      SET_YEAR (pd_yyvsp[-1].datespec.date, pd_yyvsp[0].number);
	    else
	      {
		if (pd_yyvsp[0].number > 10000)
		  {
		    SET_DAY (pd_yyvsp[-1].datespec.date, pd_yyvsp[0].number % 100);
		    SET_MONTH (pd_yyvsp[-1].datespec.date, (pd_yyvsp[0].number / 100) %100);
		    SET_YEAR (pd_yyvsp[-1].datespec.date, pd_yyvsp[0].number / 10000);
		  }
		else
		  {
		    if (pd_yyvsp[0].number < 100)
		      {
			SET_YEAR (pd_yyvsp[-1].datespec.date, pd_yyvsp[0].number);
		      }
		    else
		      {
		    	SET_HOUR (pd_yyvsp[-1].datespec.date, pd_yyvsp[0].number / 100);
		    	SET_MINUTE (pd_yyvsp[-1].datespec.date, pd_yyvsp[0].number % 100);
		      }
		    SET_MERIDIAN (pd_yyvsp[-1].datespec.date, MER24);
		  }
	      }
	    pd_yyval.datespec = pd_yyvsp[-1].datespec;
	  ;
    break;}
case 10:
#line 282 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_HOUR (pd_yyval.date, pd_yyvsp[-1].number);
	    SET_MERIDIAN (pd_yyval.date, pd_yyvsp[0].meridian);
	  ;
    break;}
case 11:
#line 288 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_HOUR (pd_yyval.date, pd_yyvsp[-3].number);
	    SET_MINUTE (pd_yyval.date, pd_yyvsp[-1].number);
	    SET_MERIDIAN (pd_yyval.date, pd_yyvsp[0].meridian);
	  ;
    break;}
case 12:
#line 295 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_HOUR (pd_yyval.date, pd_yyvsp[-3].number);
	    SET_MINUTE (pd_yyval.date, pd_yyvsp[-1].number);
	    SET_MERIDIAN (pd_yyval.date, MER24);
	    SET_TZ (pd_yyval.date, (pd_yyvsp[0].number < 0
			   ? -pd_yyvsp[0].number % 100 + (-pd_yyvsp[0].number / 100) * 60
			   : - (pd_yyvsp[0].number % 100 + (pd_yyvsp[0].number / 100) * 60)));
	  ;
    break;}
case 13:
#line 305 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_HOUR (pd_yyval.date, pd_yyvsp[-5].number);
	    SET_MINUTE (pd_yyval.date, pd_yyvsp[-3].number);
	    SET_SECOND (pd_yyval.date, pd_yyvsp[-1].number);
	    SET_MERIDIAN (pd_yyval.date, pd_yyvsp[0].meridian);
	  ;
    break;}
case 14:
#line 313 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_HOUR (pd_yyval.date, pd_yyvsp[-5].number);
	    SET_MINUTE (pd_yyval.date, pd_yyvsp[-3].number);
	    SET_SECOND (pd_yyval.date, pd_yyvsp[-1].number);
	    SET_MERIDIAN (pd_yyval.date, MER24);
	    SET_TZ (pd_yyval.date, (pd_yyvsp[0].number < 0
			 ? -pd_yyvsp[0].number % 100 + (-pd_yyvsp[0].number / 100) * 60
			 : - (pd_yyvsp[0].number % 100 + (pd_yyvsp[0].number / 100) * 60)));
	  ;
    break;}
case 15:
#line 326 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_TZ (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 16:
#line 331 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_TZ (pd_yyval.date, pd_yyvsp[0].number - 60);
	  ;
    break;}
case 17:
#line 336 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_TZ (pd_yyval.date, pd_yyvsp[-1].number - 60);
	  ;
    break;}
case 18:
#line 343 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_ORDINAL (pd_yyval.date, 1);
	    SET_NUMBER (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 19:
#line 349 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_ORDINAL (pd_yyval.date, 1);
	    SET_NUMBER (pd_yyval.date, pd_yyvsp[-1].number);
	  ;
    break;}
case 20:
#line 355 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_ORDINAL (pd_yyval.date, pd_yyvsp[-1].number);
	    SET_NUMBER (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 21:
#line 363 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MONTH (pd_yyval.date, pd_yyvsp[-2].number);
	    SET_DAY (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 22:
#line 369 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    /* Interpret as YYYY/MM/DD if $1 >= 1000, otherwise as MM/DD/YY.
	       The goal in recognizing YYYY/MM/DD is solely to support legacy
	       machine-generated dates like those in an RCS log listing.  If
	       you want portability, use the ISO 8601 format.  */
	    if (pd_yyvsp[-4].number >= 1000)
	      {
		SET_YEAR (pd_yyval.date, pd_yyvsp[-4].number);
		SET_MONTH (pd_yyval.date, pd_yyvsp[-2].number);
		SET_DAY (pd_yyval.date, pd_yyvsp[0].number);
	      }
	    else
	      {
		SET_MONTH (pd_yyval.date, pd_yyvsp[-4].number);
		SET_DAY (pd_yyval.date, pd_yyvsp[-2].number);
		SET_YEAR (pd_yyval.date, pd_yyvsp[0].number);
	      }
	  ;
    break;}
case 23:
#line 389 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    /* ISO 8601 format.  pd_yypd_yy-mm-dd.  */
	    SET_YEAR (pd_yyval.date, pd_yyvsp[-2].number);
	    SET_MONTH (pd_yyval.date, -pd_yyvsp[-1].number);
	    SET_DAY (pd_yyval.date, -pd_yyvsp[0].number);
	  ;
    break;}
case 24:
#line 397 "parsedate.y"
{
	    /* either 17-JUN-1992 or 1992-JUN-17 */
	    DATE_INIT (pd_yyval.date);
	    if (pd_yyvsp[-2].number < 32)
	      {
		SET_DAY (pd_yyval.date, pd_yyvsp[-2].number);
		SET_MONTH (pd_yyval.date, pd_yyvsp[-1].number);
		SET_YEAR (pd_yyval.date, -pd_yyvsp[0].number);
	      }
	    else
	      {
		SET_DAY (pd_yyval.date, -pd_yyvsp[0].number);
		SET_MONTH (pd_yyval.date, pd_yyvsp[-1].number);
		SET_YEAR (pd_yyval.date, pd_yyvsp[-2].number);
	      }
	  ;
    break;}
case 25:
#line 414 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MONTH (pd_yyval.date, pd_yyvsp[-1].number);
	    SET_DAY (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 26:
#line 420 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MONTH (pd_yyval.date, pd_yyvsp[-3].number);
	    SET_DAY (pd_yyval.date, pd_yyvsp[-2].number);
	    SET_YEAR (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 27:
#line 427 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MONTH (pd_yyval.date, pd_yyvsp[0].number);
	    SET_DAY (pd_yyval.date, pd_yyvsp[-1].number);
	  ;
    break;}
case 28:
#line 433 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MONTH (pd_yyval.date, pd_yyvsp[-1].number);
	    SET_DAY (pd_yyval.date, pd_yyvsp[-2].number);
	    SET_YEAR (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 29:
#line 440 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);

	    SET_ORDINAL (pd_yyval.date, 1);
	    SET_NUMBER (pd_yyval.date, pd_yyvsp[-4].number);

	    SET_MONTH (pd_yyval.date, pd_yyvsp[-3].number);
	    SET_DAY (pd_yyval.date, pd_yyvsp[-2].number);
	    SET_YEAR (pd_yyval.date, pd_yyvsp[0].number);
	    if (pd_date_union (&pd_yyval.date, &pd_yyvsp[-1].date))
	      YYERROR;
	  ;
    break;}
case 30:
#line 455 "parsedate.y"
{
	    pd_yyvsp[-1].date.second = - pd_yyvsp[-1].date.second;
	    pd_yyvsp[-1].date.minute = - pd_yyvsp[-1].date.minute;
	    pd_yyvsp[-1].date.hour = - pd_yyvsp[-1].date.hour;
	    pd_yyvsp[-1].date.day = - pd_yyvsp[-1].date.day;
	    pd_yyvsp[-1].date.month = - pd_yyvsp[-1].date.month;
	    pd_yyvsp[-1].date.year = - pd_yyvsp[-1].date.year;
	    pd_yyval.date = pd_yyvsp[-1].date;
	  ;
    break;}
case 32:
#line 469 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    if (pd_date_union (&pd_yyval.date, &pd_yyvsp[0].date))
	      YYERROR;
	  ;
    break;}
case 33:
#line 475 "parsedate.y"
{
	    if (pd_date_union (&pd_yyvsp[-1].date, &pd_yyvsp[0].date))
	      YYERROR;
	    pd_yyval.date = pd_yyvsp[-1].date;
	  ;
    break;}
case 34:
#line 483 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_YEAR (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 35:
#line 488 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_YEAR (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 36:
#line 493 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_YEAR (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 37:
#line 498 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MONTH (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 38:
#line 503 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MONTH (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 39:
#line 508 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MONTH (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 40:
#line 513 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_DAY (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 41:
#line 518 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_DAY (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 42:
#line 523 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_DAY (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 43:
#line 528 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_HOUR (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 44:
#line 533 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_HOUR (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 45:
#line 538 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_HOUR (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 46:
#line 543 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MINUTE (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 47:
#line 548 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MINUTE (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 48:
#line 553 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_MINUTE (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 49:
#line 558 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_SECOND (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 50:
#line 563 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_SECOND (pd_yyval.date, pd_yyvsp[-1].number * pd_yyvsp[0].number);
	  ;
    break;}
case 51:
#line 568 "parsedate.y"
{
	    DATE_INIT (pd_yyval.date);
	    SET_SECOND (pd_yyval.date, pd_yyvsp[0].number);
	  ;
    break;}
case 52:
#line 575 "parsedate.y"
{
	    pd_yyval.meridian = MER24;
	  ;
    break;}
case 53:
#line 579 "parsedate.y"
{
	    pd_yyval.meridian = pd_yyvsp[0].meridian;
	  ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison.simple"

  pd_yyvsp -= pd_yylen;
  pd_yyssp -= pd_yylen;
#ifdef YYLSP_NEEDED
  pd_yylsp -= pd_yylen;
#endif

#if YYDEBUG != 0
  if (pd_yydebug)
    {
      short *ssp1 = pd_yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != pd_yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++pd_yyvsp = pd_yyval;

#ifdef YYLSP_NEEDED
  pd_yylsp++;
  if (pd_yylen == 0)
    {
      pd_yylsp->first_line = pd_yylloc.first_line;
      pd_yylsp->first_column = pd_yylloc.first_column;
      pd_yylsp->last_line = (pd_yylsp-1)->last_line;
      pd_yylsp->last_column = (pd_yylsp-1)->last_column;
      pd_yylsp->text = 0;
    }
  else
    {
      pd_yylsp->last_line = (pd_yylsp+pd_yylen-1)->last_line;
      pd_yylsp->last_column = (pd_yylsp+pd_yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  pd_yyn = pd_yyr1[pd_yyn];

  pd_yystate = pd_yypgoto[pd_yyn - YYNTBASE] + *pd_yyssp;
  if (pd_yystate >= 0 && pd_yystate <= YYLAST && pd_yycheck[pd_yystate] == *pd_yyssp)
    pd_yystate = pd_yytable[pd_yystate];
  else
    pd_yystate = pd_yydefgoto[pd_yyn - YYNTBASE];

  goto pd_yynewstate;

pd_yyerrlab:   /* here on detecting error */

  if (! pd_yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++pd_yynerrs;

#ifdef YYERROR_VERBOSE
      pd_yyn = pd_yypact[pd_yystate];

      if (pd_yyn > YYFLAG && pd_yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -pd_yyn if nec to avoid negative indexes in pd_yycheck.  */
	  for (x = (pd_yyn < 0 ? -pd_yyn : 0);
	       x < (sizeof(pd_yytname) / sizeof(char *)); x++)
	    if (pd_yycheck[x + pd_yyn] == x)
	      size += strlen(pd_yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (pd_yyn < 0 ? -pd_yyn : 0);
		       x < (sizeof(pd_yytname) / sizeof(char *)); x++)
		    if (pd_yycheck[x + pd_yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, pd_yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      pd_yyerror(msg);
	      free(msg);
	    }
	  else
	    pd_yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	pd_yyerror("parse error");
    }

  goto pd_yyerrlab1;
pd_yyerrlab1:   /* here on error raised explicitly by an action */

  if (pd_yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (pd_yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (pd_yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", pd_yychar, pd_yytname[pd_yychar1]);
#endif

      pd_yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  pd_yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto pd_yyerrhandle;

pd_yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  pd_yyn = pd_yydefact[pd_yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (pd_yyn) goto pd_yydefault;
#endif

pd_yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (pd_yyssp == pd_yyss) YYABORT;
  pd_yyvsp--;
  pd_yystate = *--pd_yyssp;
#ifdef YYLSP_NEEDED
  pd_yylsp--;
#endif

#if YYDEBUG != 0
  if (pd_yydebug)
    {
      short *ssp1 = pd_yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != pd_yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

pd_yyerrhandle:

  pd_yyn = pd_yypact[pd_yystate];
  if (pd_yyn == YYFLAG)
    goto pd_yyerrdefault;

  pd_yyn += YYTERROR;
  if (pd_yyn < 0 || pd_yyn > YYLAST || pd_yycheck[pd_yyn] != YYTERROR)
    goto pd_yyerrdefault;

  pd_yyn = pd_yytable[pd_yyn];
  if (pd_yyn < 0)
    {
      if (pd_yyn == YYFLAG)
	goto pd_yyerrpop;
      pd_yyn = -pd_yyn;
      goto pd_yyreduce;
    }
  else if (pd_yyn == 0)
    goto pd_yyerrpop;

  if (pd_yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (pd_yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++pd_yyvsp = pd_yylval;
#ifdef YYLSP_NEEDED
  *++pd_yylsp = pd_yylloc;
#endif

  pd_yystate = pd_yyn;
  goto pd_yynewstate;

 pd_yyacceptlab:
  /* YYACCEPT comes here.  */
  if (pd_yyfree_stacks)
    {
      free (pd_yyss);
      free (pd_yyvs);
#ifdef YYLSP_NEEDED
      free (pd_yyls);
#endif
    }
  return 0;

 pd_yyabortlab:
  /* YYABORT comes here.  */
  if (pd_yyfree_stacks)
    {
      free (pd_yyss);
      free (pd_yyvs);
#ifdef YYLSP_NEEDED
      free (pd_yyls);
#endif
    }
  return 1;
}
#line 584 "parsedate.y"


#include <mailutils/types.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <mailutils/mutil.h>

/* Month and day table. */
static SYMBOL const month_day_tab[] = {
  { "january",	T_MONTH,  1 },
  { "february",	T_MONTH,  2 },
  { "march",	T_MONTH,  3 },
  { "april",	T_MONTH,  4 },
  { "may",	T_MONTH,  5 },
  { "june",	T_MONTH,  6 },
  { "july",	T_MONTH,  7 },
  { "august",	T_MONTH,  8 },
  { "september",T_MONTH,  9 },
  { "sept",	T_MONTH,  9 },
  { "october",	T_MONTH, 10 },
  { "november",	T_MONTH, 11 },
  { "december",	T_MONTH, 12 },
  { "sunday",	T_DAY,   0 },
  { "monday",	T_DAY,   1 },
  { "tuesday",	T_DAY,   2 },
  { "tues",	T_DAY,   2 },
  { "wednesday",T_DAY,   3 },
  { "wednes",	T_DAY,   3 },
  { "thursday",	T_DAY,   4 },
  { "thur",	T_DAY,   4 },
  { "thurs",	T_DAY,   4 },
  { "friday",	T_DAY,   5 },
  { "saturday",	T_DAY,   6 },
  { NULL, 0, 0 }
};

/* Time units table. */
static SYMBOL const units_tab[] = {
  { "year",	T_YEAR_UNIT,	1 },
  { "month",	T_MONTH_UNIT,	1 },
  { "fortnight",T_DAY_UNIT,	14 },
  { "week",	T_DAY_UNIT,	7 },
  { "day",	T_DAY_UNIT,	1 },
  { "hour",	T_HOUR_UNIT,	1 },
  { "minute",	T_MINUTE_UNIT,	1 },
  { "min",	T_MINUTE_UNIT,	1 },
  { "second",	T_SEC_UNIT,	1 },
  { "sec",	T_SEC_UNIT,	1 },
  { NULL, 0, 0 }
};

/* Assorted relative-time words. */
static SYMBOL const other_tab[] = {
  { "tomorrow",	T_MINUTE_UNIT,	1 * 24 * 60 },
  { "yesterday",T_MINUTE_UNIT,	-1 * 24 * 60 },
  { "today",	T_MINUTE_UNIT,	0 },
  { "now",	T_MINUTE_UNIT,	0 },
  { "last",	T_UNUMBER,	-1 },
  { "this",	T_MINUTE_UNIT,	0 },
  { "next",	T_UNUMBER,	1 },
  { "first",	T_UNUMBER,	1 },
/*  { "second",	T_UNUMBER,	2 }, */
  { "third",	T_UNUMBER,	3 },
  { "fourth",	T_UNUMBER,	4 },
  { "fifth",	T_UNUMBER,	5 },
  { "sixth",	T_UNUMBER,	6 },
  { "seventh",	T_UNUMBER,	7 },
  { "eighth",	T_UNUMBER,	8 },
  { "ninth",	T_UNUMBER,	9 },
  { "tenth",	T_UNUMBER,	10 },
  { "eleventh",	T_UNUMBER,	11 },
  { "twelfth",	T_UNUMBER,	12 },
  { "ago",	T_AGO,	        1 },
  { NULL, 0, 0 }
};

/* The timezone table. */
static SYMBOL const tz_tab[] = {
  { "gmt",	T_ZONE,     HOUR ( 0) },	/* Greenwich Mean */
  { "ut",	T_ZONE,     HOUR ( 0) },	/* Universal (Coordinated) */
  { "utc",	T_ZONE,     HOUR ( 0) },
  { "wet",	T_ZONE,     HOUR ( 0) },	/* Western European */
  { "bst",	T_DAYZONE,  HOUR ( 0) },	/* British Summer */
  { "wat",	T_ZONE,     HOUR ( 1) },	/* West Africa */
  { "at",	T_ZONE,     HOUR ( 2) },	/* Azores */
#if	0
  /* For completeness.  BST is also British Summer, and GST is
   * also Guam Standard. */
  { "bst",	T_ZONE,     HOUR ( 3) },	/* Brazil Standard */
  { "gst",	T_ZONE,     HOUR ( 3) },	/* Greenland Standard */
#endif
#if 0
  { "nft",	T_ZONE,     HOUR (3.5) },	/* Newfoundland */
  { "nst",	T_ZONE,     HOUR (3.5) },	/* Newfoundland Standard */
  { "ndt",	T_DAYZONE,  HOUR (3.5) },	/* Newfoundland Daylight */
#endif
  { "ast",	T_ZONE,     HOUR ( 4) },	/* Atlantic Standard */
  { "adt",	T_DAYZONE,  HOUR ( 4) },	/* Atlantic Daylight */
  { "est",	T_ZONE,     HOUR ( 5) },	/* Eastern Standard */
  { "edt",	T_DAYZONE,  HOUR ( 5) },	/* Eastern Daylight */
  { "cst",	T_ZONE,     HOUR ( 6) },	/* Central Standard */
  { "cdt",	T_DAYZONE,  HOUR ( 6) },	/* Central Daylight */
  { "mst",	T_ZONE,     HOUR ( 7) },	/* Mountain Standard */
  { "mdt",	T_DAYZONE,  HOUR ( 7) },	/* Mountain Daylight */
  { "pst",	T_ZONE,     HOUR ( 8) },	/* Pacific Standard */
  { "pdt",	T_DAYZONE,  HOUR ( 8) },	/* Pacific Daylight */
  { "yst",	T_ZONE,     HOUR ( 9) },	/* Yukon Standard */
  { "ydt",	T_DAYZONE,  HOUR ( 9) },	/* Yukon Daylight */
  { "hst",	T_ZONE,     HOUR (10) },	/* Hawaii Standard */
  { "hdt",	T_DAYZONE,  HOUR (10) },	/* Hawaii Daylight */
  { "cat",	T_ZONE,     HOUR (10) },	/* Central Alaska */
  { "ahst",	T_ZONE,     HOUR (10) },	/* Alaska-Hawaii Standard */
  { "nt",	T_ZONE,     HOUR (11) },	/* Nome */
  { "idlw",	T_ZONE,     HOUR (12) },	/* International Date Line West */
  { "cet",	T_ZONE,     -HOUR (1) },	/* Central European */
  { "met",	T_ZONE,     -HOUR (1) },	/* Middle European */
  { "mewt",	T_ZONE,     -HOUR (1) },	/* Middle European Winter */
  { "mest",	T_DAYZONE,  -HOUR (1) },	/* Middle European Summer */
  { "mesz",	T_DAYZONE,  -HOUR (1) },	/* Middle European Summer */
  { "swt",	T_ZONE,     -HOUR (1) },	/* Swedish Winter */
  { "sst",	T_DAYZONE,  -HOUR (1) },	/* Swedish Summer */
  { "fwt",	T_ZONE,     -HOUR (1) },	/* French Winter */
  { "fst",	T_DAYZONE,  -HOUR (1) },	/* French Summer */
  { "eet",	T_ZONE,     -HOUR (2) },	/* Eastern Europe, USSR Zone 1 */
  { "bt",	T_ZONE,     -HOUR (3) },	/* Baghdad, USSR Zone 2 */
#if 0
  { "it",	T_ZONE,     -HOUR (3.5) },/* Iran */
#endif
  { "zp4",	T_ZONE,     -HOUR (4) },	/* USSR Zone 3 */
  { "zp5",	T_ZONE,     -HOUR (5) },	/* USSR Zone 4 */
#if 0
  { "ist",	T_ZONE,     -HOUR (5.5) },/* Indian Standard */
#endif
  { "zp6",	T_ZONE,     -HOUR (6) },	/* USSR Zone 5 */
#if	0
  /* For completeness.  NST is also Newfoundland Standard, and SST is
   * also Swedish Summer. */
  { "nst",	T_ZONE,     -HOUR (6.5) },/* North Sumatra */
  { "sst",	T_ZONE,     -HOUR (7) },	/* South Sumatra, USSR Zone 6 */
#endif	/* 0 */
  { "wast",	T_ZONE,     -HOUR (7) },	/* West Australian Standard */
  { "wadt",	T_DAYZONE,  -HOUR (7) },	/* West Australian Daylight */
#if 0
  { "jt",	T_ZONE,     -HOUR (7.5) },/* Java (3pm in Cronusland!) */
#endif
  { "cct",	T_ZONE,     -HOUR (8) },	/* China Coast, USSR Zone 7 */
  { "jst",	T_ZONE,     -HOUR (9) },	/* Japan Standard, USSR Zone 8 */
#if 0
  { "cast",	T_ZONE,     -HOUR (9.5) },/* Central Australian Standard */
  { "cadt",	T_DAYZONE,  -HOUR (9.5) },/* Central Australian Daylight */
#endif
  { "east",	T_ZONE,     -HOUR (10) },	/* Eastern Australian Standard */
  { "eadt",	T_DAYZONE,  -HOUR (10) },	/* Eastern Australian Daylight */
  { "gst",	T_ZONE,     -HOUR (10) },	/* Guam Standard, USSR Zone 9 */
  { "nzt",	T_ZONE,     -HOUR (12) },	/* New Zealand */
  { "nzst",	T_ZONE,     -HOUR (12) },	/* New Zealand Standard */
  { "nzdt",	T_DAYZONE,  -HOUR (12) },	/* New Zealand Daylight */
  { "idle",	T_ZONE,     -HOUR (12) },	/* International Date Line
						   East */
  {  NULL, 0, 0  }
};

/* Military timezone table. */
static SYMBOL const mil_tz_tab[] = {
  { "a",	T_ZONE,	HOUR (  1) },
  { "b",	T_ZONE,	HOUR (  2) },
  { "c",	T_ZONE,	HOUR (  3) },
  { "d",	T_ZONE,	HOUR (  4) },
  { "e",	T_ZONE,	HOUR (  5) },
  { "f",	T_ZONE,	HOUR (  6) },
  { "g",	T_ZONE,	HOUR (  7) },
  { "h",	T_ZONE,	HOUR (  8) },
  { "i",	T_ZONE,	HOUR (  9) },
  { "k",	T_ZONE,	HOUR ( 10) },
  { "l",	T_ZONE,	HOUR ( 11) },
  { "m",	T_ZONE,	HOUR ( 12) },
  { "n",	T_ZONE,	HOUR (- 1) },
  { "o",	T_ZONE,	HOUR (- 2) },
  { "p",	T_ZONE,	HOUR (- 3) },
  { "q",	T_ZONE,	HOUR (- 4) },
  { "r",	T_ZONE,	HOUR (- 5) },
  { "s",	T_ZONE,	HOUR (- 6) },
  { "t",	T_ZONE,	HOUR (- 7) },
  { "u",	T_ZONE,	HOUR (- 8) },
  { "v",	T_ZONE,	HOUR (- 9) },
  { "w",	T_ZONE,	HOUR (-10) },
  { "x",	T_ZONE,	HOUR (-11) },
  { "y",	T_ZONE,	HOUR (-12) },
  { "z",	T_ZONE,	HOUR (  0) },
  { NULL, 0, 0 }
};




/* ARGSUSED */
static int
pd_yyerror (char *s ARG_UNUSED)
{
  return 0;
}

static int
norm_hour (int hours, MERIDIAN meridian)
{
  switch (meridian)
    {
    case MER24:
      if (hours < 0 || hours > 23)
	return -1;
      return hours;
      
    case MERam:
      if (hours < 1 || hours > 12)
	return -1;
      if (hours == 12)
	hours = 0;
      return hours;
      
    case MERpm:
      if (hours < 1 || hours > 12)
	return -1;
      if (hours == 12)
	hours = 0;
      return hours + 12;
      
    default:
      abort ();
    }
  /* NOTREACHED */
}

static int
norm_year (int year)
{
  if (year < 0)
    year = -year;
  
  /* XPG4 suggests that years 00-68 map to 2000-2068, and
     years 69-99 map to 1969-1999.  */
  if (year < 69)
    year += 2000;
  else if (year < 100)
    year += 1900;

  return year;
}

static int
sym_lookup (char *buff)
{
  register char *p;
  register char *q;
  register const SYMBOL *tp;
  int i;
  int abbrev;
  
  /* Make it lowercase. */
  for (p = buff; *p; p++)
    if (ISUPPER ((unsigned char) *p))
      *p = tolower (*p);
  
  if (strcmp (buff, "am") == 0 || strcmp (buff, "a.m.") == 0)
    {
      pd_yylval.meridian = MERam;
      return T_MERIDIAN;
    }
  if (strcmp (buff, "pm") == 0 || strcmp (buff, "p.m.") == 0)
    {
      pd_yylval.meridian = MERpm;
      return T_MERIDIAN;
    }
  
  /* See if we have an abbreviation for a month. */
  if (strlen (buff) == 3)
    abbrev = 1;
  else if (strlen (buff) == 4 && buff[3] == '.')
    {
      abbrev = 1;
      buff[3] = '\0';
    }
  else
    abbrev = 0;

  for (tp = month_day_tab; tp->name; tp++)
    {
      if (abbrev)
	{
	  if (strncmp (buff, tp->name, 3) == 0)
	    {
	      pd_yylval.number = tp->value;
	      return tp->type;
	    }
	}
      else if (strcmp (buff, tp->name) == 0)
	{
	  pd_yylval.number = tp->value;
	  return tp->type;
	}
    }

  for (tp = tz_tab; tp->name; tp++)
    if (strcmp (buff, tp->name) == 0)
      {
	pd_yylval.number = tp->value;
	return tp->type;
      }

  if (strcmp (buff, "dst") == 0)
    return T_DST;

  for (tp = units_tab; tp->name; tp++)
    if (strcmp (buff, tp->name) == 0)
      {
	pd_yylval.number = tp->value;
	return tp->type;
      }

  /* Strip off any plural and try the units table again. */
  i = strlen (buff) - 1;
  if (buff[i] == 's')
    {
      buff[i] = '\0';
      for (tp = units_tab; tp->name; tp++)
	if (strcmp (buff, tp->name) == 0)
	  {
	    pd_yylval.number = tp->value;
	    return tp->type;
	  }
      buff[i] = 's';		/* Put back for "this" in other_tab. */
    }

  for (tp = other_tab; tp->name; tp++)
    if (strcmp (buff, tp->name) == 0)
      {
	pd_yylval.number = tp->value;
	return tp->type;
      }

  /* Military timezones. */
  if (buff[1] == '\0' && ISALPHA ((unsigned char) *buff))
    {
      for (tp = mil_tz_tab; tp->name; tp++)
	if (strcmp (buff, tp->name) == 0)
	  {
	    pd_yylval.number = tp->value;
	    return tp->type;
	  }
    }

  /* Drop out any periods and try the timezone table again. */
  for (i = 0, p = q = buff; *q; q++)
    if (*q != '.')
      *p++ = *q;
    else
      i++;
  *p = '\0';
  if (i)
    for (tp = tz_tab; tp->name; tp++)
      if (strcmp (buff, tp->name) == 0)
	{
	  pd_yylval.number = tp->value;
	  return tp->type;
	}

  return T_ID;
}

static int
pd_yylex ()
{
  register unsigned char c;
  register char *p;
  char buff[20];
  int count;
  int sign;

  for (;;)
    {
      while (ISSPACE ((unsigned char) *pd_yyinput))
	pd_yyinput++;

      if (ISDIGIT (c = *pd_yyinput) || c == '-' || c == '+')
	{
	  if (c == '-' || c == '+')
	    {
	      sign = c == '-' ? -1 : 1;
	      if (!ISDIGIT (*++pd_yyinput))
		/* skip the '-' sign */
		continue;
	    }
	  else
	    sign = 0;
	  for (pd_yylval.number = 0; ISDIGIT (c = *pd_yyinput++);)
	    pd_yylval.number = 10 * pd_yylval.number + c - '0';
	  pd_yyinput--;
	  if (sign < 0)
	    pd_yylval.number = -pd_yylval.number;
	  return sign ? T_SNUMBER : T_UNUMBER;
	}
      if (ISALPHA (c))
	{
	  for (p = buff; (c = *pd_yyinput++, ISALPHA (c)) || c == '.';)
	    if (p < &buff[sizeof buff - 1])
	      *p++ = c;
	  *p = '\0';
	  pd_yyinput--;
	  return sym_lookup (buff);
	}
      if (c != '(')
	return *pd_yyinput++;
      count = 0;
      do
	{
	  c = *pd_yyinput++;
	  if (c == '\0')
	    return c;
	  if (c == '(')
	    count++;
	  else if (c == ')')
	    count--;
	}
      while (count > 0);
    }
}

#define TM_YEAR_ORIGIN 1900

/* Yield A - B, measured in seconds.  */
static long
difftm (struct tm *a, struct tm *b)
{
  int ay = a->tm_year + (TM_YEAR_ORIGIN - 1);
  int by = b->tm_year + (TM_YEAR_ORIGIN - 1);
  long days = (
  /* difference in day of year */
		a->tm_yday - b->tm_yday
  /* + intervening leap days */
		+ ((ay >> 2) - (by >> 2))
		- (ay / 100 - by / 100)
		+ ((ay / 100 >> 2) - (by / 100 >> 2))
  /* + difference in years * 365 */
		+ (long) (ay - by) * 365
  );
  return (60 * (60 * (24 * days + (a->tm_hour - b->tm_hour))
		+ (a->tm_min - b->tm_min))
	  + (a->tm_sec - b->tm_sec));
}

int
mu_parse_date (const char *p, time_t *rettime, const time_t *now)
{
  struct tm tm, tm0, *tmp;
  time_t start;

  pd_yyinput = p;
  start = now ? *now : time ((time_t *) NULL);
  tmp = localtime (&start);
  if (!tmp)
    return -1;

  tm.tm_isdst = tmp->tm_isdst;

  if (pd_yyparse ())
    return -1;
  
  if (!MASK_IS_SET (pd.date.mask, PD_MASK_YEAR))
    SET_YEAR (pd.date, tmp->tm_year + TM_YEAR_ORIGIN);
  if (!MASK_IS_SET (pd.date.mask, PD_MASK_MONTH))
    SET_MONTH (pd.date, tmp->tm_mon + 1);
  if (!MASK_IS_SET (pd.date.mask, PD_MASK_DAY))
    SET_DAY (pd.date, tmp->tm_mday);
  if (!MASK_IS_SET (pd.date.mask, PD_MASK_HOUR))
    SET_HOUR (pd.date, tmp->tm_hour);
  if (!MASK_IS_SET (pd.date.mask, PD_MASK_MERIDIAN))
    SET_MERIDIAN (pd.date, MER24);
  if (!MASK_IS_SET (pd.date.mask, PD_MASK_MINUTE))
    SET_MINUTE (pd.date, tmp->tm_min);
  if (!MASK_IS_SET (pd.date.mask, PD_MASK_SECOND))
    SET_SECOND (pd.date, tmp->tm_sec);
  
  tm.tm_year = norm_year (pd.date.year) - TM_YEAR_ORIGIN + pd.rel.year;
  tm.tm_mon = pd.date.month - 1 + pd.rel.month;
  tm.tm_mday = pd.date.day + pd.rel.day;
  if (MASK_TEST (pd.date.mask, PD_MASK_TIME)
      || (pd.rel.mask && !MASK_TEST (pd.date.mask, PD_MASK_DATE)
	  && !MASK_TEST (pd.date.mask, PD_MASK_DOW)))
    {
      tm.tm_hour = norm_hour (pd.date.hour, pd.date.meridian);
      if (tm.tm_hour < 0)
	return -1;
      tm.tm_min = pd.date.minute;
      tm.tm_sec = pd.date.second;
    }
  else
    {
      tm.tm_hour = tm.tm_min = tm.tm_sec = 0;
    }
  tm.tm_hour += pd.rel.hour;
  tm.tm_min += pd.rel.minute;
  tm.tm_sec += pd.rel.second;

  /* Let mktime deduce tm_isdst if we have an absolute timestamp,
     or if the relative timestamp mentions days, months, or years.  */
  if (MASK_TEST (pd.date.mask, PD_MASK_DATE | PD_MASK_DOW | PD_MASK_TIME)
      || MASK_TEST (pd.rel.mask, PD_MASK_DOW | PD_MASK_MONTH | PD_MASK_YEAR))
    tm.tm_isdst = -1;

  tm0 = tm;

  start = mktime (&tm);

  if (start == (time_t) -1)
    {

      /* Guard against falsely reporting errors near the time_t boundaries
         when parsing times in other time zones.  For example, if the min
         time_t value is 1970-01-01 00:00:00 UTC and we are 8 hours ahead
         of UTC, then the min localtime value is 1970-01-01 08:00:00; if
         we apply mktime to 1970-01-01 00:00:00 we will get an error, so
         we apply mktime to 1970-01-02 08:00:00 instead and adjust the time
         zone by 24 hours to compensate.  This algorithm assumes that
         there is no DST transition within a day of the time_t boundaries.  */
      if (MASK_TEST (pd.date.mask, PD_MASK_TZ))
	{
	  tm = tm0;
	  if (tm.tm_year <= EPOCH - TM_YEAR_ORIGIN)
	    {
	      tm.tm_mday++;
	      pd.date.tz -= 24 * 60;
	    }
	  else
	    {
	      tm.tm_mday--;
	      pd.date.tz += 24 * 60;
	    }
	  start = mktime (&tm);
	}

      if (start == (time_t) -1)
	return -1;
    }

  if (MASK_TEST (pd.date.mask, PD_MASK_DOW)
      && !MASK_TEST (pd.date.mask, PD_MASK_DATE))
    {
      tm.tm_mday += ((pd.date.number - tm.tm_wday + 7) % 7
		     + 7 * (pd.date.ordinal - (0 < pd.date.ordinal)));
      start = mktime (&tm);
      if (start == (time_t) -1)
	return -1;
    }
  
  if (MASK_TEST (pd.date.mask, PD_MASK_TZ))
    {
      long delta;
      struct tm *gmt = gmtime (&start);
      if (gmt)
	{
	  delta = pd.date.tz * 60L + difftm (&tm, gmt);
	  if ((start + delta < start) != (delta < 0))
	    return -1;		/* time_t overflow */
	  start += delta;
	}
    }
  
  *rettime = start;
  return 0;
}

#ifdef STANDALONE
int
main (int argc, char *argv[])
{
  char buff[MAX_BUFF_LEN + 1];
  time_t d;

  if (argc > 1 && strcmp (argv[1], "-d") == 0)
    pd_yydebug++;
  printf ("Enter date, or blank line to exit.\n\t> ");
  fflush (stdout);

  buff[MAX_BUFF_LEN] = 0;
  while (fgets (buff, MAX_BUFF_LEN, stdin) && buff[0])
    {
      d = get_date (buff, (time_t *) NULL);
      if (d == -1)
	printf ("Bad format - couldn't convert.\n");
      else
	printf ("%s", ctime (&d));
      printf ("\t> ");
      fflush (stdout);
    }
  exit (0);
  /* NOTREACHED */
}

#endif
