/*
 * Decompiled with CFR 0.152.
 */
package DEAL;

import DEAL.DEAL_Properties;
import DEAL.DES_Algorithm;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class DEAL_Algorithm {
    static final String NAME = "DEAL_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final boolean TRACE = DEAL_Properties.isTraceable("DEAL_Algorithm");
    static final int BLOCK_SIZE = 16;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static void debug(String string) {
        ((PrintWriter)null).println(">>> DEAL_Algorithm: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> DEAL_Algorithm." + string);
        }
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        int n = byArray.length / 8;
        if (n != 2 && n != 3 && n != 4) {
            throw new InvalidKeyException("Incorrect key length");
        }
        byte[][] byArray2 = new byte[n][8];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < 8) {
                byArray2[n3][n4] = byArray[n2++];
                ++n4;
            }
            ++n3;
        }
        byte[][] byArray3 = null;
        byte[] byArray4 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        Object object = DES_Algorithm.makeKey(byArray4);
        switch (n) {
            case 2: {
                byArray3 = new byte[6][8];
                byArray3[0] = DES_Algorithm.blockEncrypt(byArray2[0], 0, object);
                byArray3[1] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(byArray2[1], byArray3[0]), 0, object);
                byArray3[2] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[0], 1), byArray3[1]), 0, object);
                byArray3[3] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[1], 2), byArray3[2]), 0, object);
                byArray3[4] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[0], 3), byArray3[3]), 0, object);
                byArray3[5] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[1], 4), byArray3[4]), 0, object);
                break;
            }
            case 3: {
                byArray3 = new byte[6][8];
                byArray3[0] = DES_Algorithm.blockEncrypt(byArray2[0], 0, object);
                byArray3[1] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(byArray2[1], byArray3[0]), 0, object);
                byArray3[2] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(byArray2[2], byArray3[1]), 0, object);
                byArray3[3] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[0], 1), byArray3[2]), 0, object);
                byArray3[4] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[1], 2), byArray3[3]), 0, object);
                byArray3[5] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[2], 3), byArray3[4]), 0, object);
                break;
            }
            case 4: {
                byArray3 = new byte[8][8];
                byArray3[0] = DES_Algorithm.blockEncrypt(byArray2[0], 0, object);
                byArray3[1] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(byArray2[1], byArray3[0]), 0, object);
                byArray3[2] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(byArray2[2], byArray3[1]), 0, object);
                byArray3[3] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(byArray2[3], byArray3[2]), 0, object);
                byArray3[4] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[0], 1), byArray3[3]), 0, object);
                byArray3[5] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[1], 2), byArray3[4]), 0, object);
                byArray3[6] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[2], 3), byArray3[5]), 0, object);
                byArray3[7] = DES_Algorithm.blockEncrypt(DEAL_Algorithm.xor(DEAL_Algorithm.xor(byArray2[3], 4), byArray3[6]), 0, object);
            }
        }
        Object[] objectArray = new Object[byArray3.length];
        n3 = 0;
        while (n3 < byArray3.length) {
            objectArray[n3] = DES_Algorithm.makeKey(byArray3[n3]);
            ++n3;
        }
        return objectArray;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        Object[] objectArray = (Object[])object;
        int n2 = objectArray.length;
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, n, byArray2, 0, 8);
        System.arraycopy(byArray, n + 8, byArray3, 0, 8);
        DES_Algorithm.IP(byArray2);
        DES_Algorithm.IP(byArray3);
        byte[] byArray4 = (byte[])byArray2.clone();
        DES_Algorithm.encrypt(byArray2, objectArray[0]);
        byte[] byArray5 = DEAL_Algorithm.xor(byArray2, byArray3);
        byArray3 = (byte[])byArray5.clone();
        DES_Algorithm.encrypt(byArray5, objectArray[1]);
        byArray2 = DEAL_Algorithm.xor(byArray5, byArray4);
        byArray4 = (byte[])byArray2.clone();
        DES_Algorithm.encrypt(byArray2, objectArray[2]);
        byArray5 = DEAL_Algorithm.xor(byArray2, byArray3);
        byArray3 = (byte[])byArray5.clone();
        DES_Algorithm.encrypt(byArray5, objectArray[3]);
        byArray2 = DEAL_Algorithm.xor(byArray5, byArray4);
        byArray4 = (byte[])byArray2.clone();
        DES_Algorithm.encrypt(byArray2, objectArray[4]);
        byArray5 = DEAL_Algorithm.xor(byArray2, byArray3);
        byArray3 = (byte[])byArray5.clone();
        DES_Algorithm.encrypt(byArray5, objectArray[5]);
        byArray2 = DEAL_Algorithm.xor(byArray5, byArray4);
        if (n2 == 8) {
            byArray4 = (byte[])byArray2.clone();
            DES_Algorithm.encrypt(byArray2, objectArray[6]);
            byArray5 = DEAL_Algorithm.xor(byArray2, byArray3);
            byArray3 = (byte[])byArray5.clone();
            DES_Algorithm.encrypt(byArray5, objectArray[7]);
            byArray2 = DEAL_Algorithm.xor(byArray5, byArray4);
        }
        DES_Algorithm.FP(byArray2);
        DES_Algorithm.FP(byArray3);
        byte[] byArray6 = new byte[16];
        System.arraycopy(byArray2, 0, byArray6, 0, 8);
        System.arraycopy(byArray3, 0, byArray6, 8, 8);
        return byArray6;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        byte[] byArray2;
        byte[] byArray3;
        Object[] objectArray = (Object[])object;
        int n2 = objectArray.length;
        byte[] byArray4 = new byte[8];
        byte[] byArray5 = new byte[8];
        System.arraycopy(byArray, n, byArray4, 0, 8);
        System.arraycopy(byArray, n + 8, byArray5, 0, 8);
        DES_Algorithm.IP(byArray4);
        DES_Algorithm.IP(byArray5);
        if (n2 == 8) {
            byArray3 = (byte[])byArray5.clone();
            DES_Algorithm.encrypt(byArray5, objectArray[7]);
            byArray2 = DEAL_Algorithm.xor(byArray4, byArray5);
            byArray4 = (byte[])byArray2.clone();
            DES_Algorithm.encrypt(byArray2, objectArray[6]);
            byArray5 = DEAL_Algorithm.xor(byArray3, byArray2);
        }
        byArray3 = (byte[])byArray5.clone();
        DES_Algorithm.encrypt(byArray5, objectArray[5]);
        byArray2 = DEAL_Algorithm.xor(byArray4, byArray5);
        byArray4 = (byte[])byArray2.clone();
        DES_Algorithm.encrypt(byArray2, objectArray[4]);
        byArray5 = DEAL_Algorithm.xor(byArray3, byArray2);
        byArray3 = (byte[])byArray5.clone();
        DES_Algorithm.encrypt(byArray5, objectArray[3]);
        byArray2 = DEAL_Algorithm.xor(byArray4, byArray5);
        byArray4 = (byte[])byArray2.clone();
        DES_Algorithm.encrypt(byArray2, objectArray[2]);
        byArray5 = DEAL_Algorithm.xor(byArray3, byArray2);
        byArray3 = (byte[])byArray5.clone();
        DES_Algorithm.encrypt(byArray5, objectArray[1]);
        byArray2 = DEAL_Algorithm.xor(byArray4, byArray5);
        byArray4 = (byte[])byArray2.clone();
        DES_Algorithm.encrypt(byArray2, objectArray[0]);
        byArray5 = DEAL_Algorithm.xor(byArray3, byArray2);
        DES_Algorithm.FP(byArray4);
        DES_Algorithm.FP(byArray5);
        byte[] byArray6 = new byte[16];
        System.arraycopy(byArray4, 0, byArray6, 0, 8);
        System.arraycopy(byArray5, 0, byArray6, 8, 8);
        return byArray6;
    }

    public static boolean self_test() {
        boolean bl = DES_Algorithm.self_test();
        try {
            Object object;
            byte[] byArray;
            if (!bl) {
                throw new RuntimeException("DES self-test failed");
            }
            byte[] byArray2 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, 16, 50, 84, 118, -104, -70, -36, -2};
            byte[] byArray3 = DEAL_Algorithm.fromString("0123456789ABCDEF1032547698BADCFE");
            byte[] byArray4 = DEAL_Algorithm.fromString("419C64EC7C579C4CAC81A4ED78D9374B");
            bl = DEAL_Algorithm.areEqual(byArray4, byArray = DEAL_Algorithm.blockEncrypt(byArray3, 0, object = DEAL_Algorithm.makeKey(byArray2)));
            if (!bl) {
                throw new RuntimeException("Encryption failed");
            }
            byArray = DEAL_Algorithm.blockDecrypt(byArray4, 0, object);
            bl = DEAL_Algorithm.areEqual(byArray3, byArray);
            if (!bl) {
                throw new RuntimeException("Decryption failed");
            }
            bl = DEAL_Algorithm.self_test(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static int blockSize() {
        return 16;
    }

    public static final int getRounds(int n) {
        switch (n) {
            case 16: 
            case 24: {
                return 6;
            }
        }
        return 8;
    }

    private static final byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = (byte[])byArray.clone();
        int n = 0;
        while (n < 8) {
            int n2 = n;
            byArray3[n2] = (byte)(byArray3[n2] ^ byArray2[n]);
            ++n;
        }
        return byArray3;
    }

    private static final byte[] xor(byte[] byArray, int n) {
        byte[] byArray2 = (byte[])byArray.clone();
        byArray2[0] = (byte)(byArray2[0] ^ 128 >>> n - 1 & 0xFF);
        return byArray2;
    }

    private static boolean self_test(int n) {
        boolean bl = false;
        try {
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[16];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)n2;
                ++n2;
            }
            n2 = 0;
            while (n2 < 16) {
                byArray2[n2] = (byte)n2;
                ++n2;
            }
            Object object = DEAL_Algorithm.makeKey(byArray);
            byte[] byArray3 = DEAL_Algorithm.blockEncrypt(byArray2, 0, object);
            byte[] byArray4 = DEAL_Algorithm.blockDecrypt(byArray3, 0, object);
            bl = DEAL_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static final boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static byte[] fromString(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        if (n % 2 == 1) {
            byArray[n3++] = (byte)DEAL_Algorithm.fromDigit(string.charAt(n2++));
        }
        while (n2 < n) {
            byArray[n3++] = (byte)(DEAL_Algorithm.fromDigit(string.charAt(n2++)) << 4 | DEAL_Algorithm.fromDigit(string.charAt(n2++)));
        }
        return byArray;
    }

    public static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex digit '" + c + "'");
    }

    private static final String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        DEAL_Algorithm.self_test();
        DEAL_Algorithm.self_test(24);
        DEAL_Algorithm.self_test(32);
    }
}

